/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.exception;

import com.oracle.bmc.auth.exception.AuthClientException;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.util.internal.Validate;

public class AuthClientNotAuthorizedException
extends AuthClientException {
    private static final int STATUS_CODE_UNAUTHORIZED = 401;
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE = "Client is unauthorized. ";

    public AuthClientNotAuthorizedException(BmcException e) {
        this(MESSAGE + e.getMessage(), e);
    }

    public AuthClientNotAuthorizedException(String message, BmcException cause) {
        super(message, AuthClientNotAuthorizedException.validate(cause));
    }

    private static BmcException validate(BmcException cause) {
        Validate.notNull(cause, "cause must not be null", new Object[0]);
        Validate.isTrue(AuthClientNotAuthorizedException.matches(cause), "status code of cause must match '401', but was '" + cause.getStatusCode() + "'", new Object[0]);
        return cause;
    }

    public static boolean matches(BmcException cause) {
        return cause.getStatusCode() == 401;
    }
}

