/*
 * Decompiled with CFR 0.152.
 */
package org.josql.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Utilities {
    private static final String F = "f";
    private static final String E = "e";
    private static final String A = "a";
    private static final String N = "n";
    public static final int GT = 0;
    public static final int GTE = 1;
    public static final int LT = 2;
    public static final int LTE = 3;
    public static final int EQ = 4;
    private static Map pCNames = new HashMap();
    private static Map primNames = new HashMap();
    private static Map primCls = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public static Class getObjectClass(Class c) {
        if (c.isPrimitive()) {
            String n = c.getName();
            if (n.equals(Boolean.TYPE.getName())) {
                return Boolean.class;
            }
            if (n.equals(Long.TYPE.getName())) {
                return Long.class;
            }
            if (n.equals(Short.TYPE.getName())) {
                return Short.class;
            }
            if (n.equals(Integer.TYPE.getName())) {
                return Integer.class;
            }
            if (n.equals(Double.TYPE.getName())) {
                return Double.class;
            }
            if (n.equals(Character.TYPE.getName())) {
                return Character.class;
            }
            if (n.equals(Float.TYPE.getName())) {
                return Float.class;
            }
            if (n.equals(Byte.TYPE.getName())) {
                return Byte.class;
            }
        }
        return c;
    }

    public static Class getPrimitiveClass(Class c) {
        return (Class)primCls.get(c.getName());
    }

    public static boolean isPrimitiveClass(Class c) {
        return primNames.containsKey(c.getName());
    }

    public static boolean getResult(boolean v, boolean n) {
        if (v) {
            return !n;
        }
        return n;
    }

    public static boolean matches(Object l, Object r, boolean ignoreCase, int type, boolean not) {
        if (l instanceof Collection) {
            if (r instanceof Collection) {
                Collection cl = (Collection)l;
                Collection cr = (Collection)r;
                boolean lisra = cl instanceof List;
                boolean risra = cr instanceof List;
                List rl = null;
                if (risra) {
                    rl = (List)cr;
                }
                int rs = cr.size() - 1;
                if (lisra) {
                    int s;
                    List ll = (List)cl;
                    for (int i = s = ll.size() - 1; i > -1; --i) {
                        l = Utilities.lowerValue(ll.get(i), ignoreCase);
                        if (risra) {
                            for (int j = rs; j > -1; --j) {
                                r = Utilities.lowerValue(rl.get(j), ignoreCase);
                                if (Utilities.compare2(l, r, type, not)) continue;
                                return false;
                            }
                            continue;
                        }
                        Iterator it = cr.iterator();
                        while (it.hasNext()) {
                            r = Utilities.lowerValue(it.next(), ignoreCase);
                            if (Utilities.compare2(l, r, type, not)) continue;
                            return false;
                        }
                    }
                } else {
                    Iterator it = cl.iterator();
                    while (it.hasNext()) {
                        l = Utilities.lowerValue(it.next(), ignoreCase);
                        if (risra) {
                            for (int j = rs; j > -1; --j) {
                                r = Utilities.lowerValue(rl.get(j), ignoreCase);
                                if (Utilities.compare2(l, r, type, not)) continue;
                                return false;
                            }
                            continue;
                        }
                        Iterator itr = cr.iterator();
                        while (itr.hasNext()) {
                            r = Utilities.lowerValue(itr.next(), ignoreCase);
                            if (Utilities.compare2(l, r, type, not)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            Collection cl = (Collection)l;
            r = Utilities.lowerValue(r, ignoreCase);
            if (cl instanceof List) {
                int ls;
                List ll = (List)cl;
                for (int i = ls = cl.size() - 1; i > -1; --i) {
                    l = Utilities.lowerValue(ll.get(i), ignoreCase);
                    if (Utilities.compare2(l, r, type, not)) continue;
                    return false;
                }
            } else {
                Iterator cli = cl.iterator();
                while (cli.hasNext()) {
                    l = Utilities.lowerValue(cli.next(), ignoreCase);
                    if (Utilities.compare2(l, r, type, not)) continue;
                    return false;
                }
            }
            return true;
        }
        if (r instanceof Collection) {
            l = Utilities.lowerValue(l, ignoreCase);
            Collection cr = (Collection)r;
            if (cr instanceof List) {
                int rs;
                List rl = (List)cr;
                for (int i = rs = rl.size() - 1; i > -1; --i) {
                    r = Utilities.lowerValue(rl.get(i), ignoreCase);
                    if (Utilities.compare2(l, r, type, not)) continue;
                    return false;
                }
            } else {
                Iterator cri = cr.iterator();
                while (cri.hasNext()) {
                    r = Utilities.lowerValue(cri.next(), ignoreCase);
                    if (Utilities.compare2(l, r, type, not)) continue;
                    return false;
                }
            }
            return true;
        }
        return Utilities.compare2(Utilities.lowerValue(l, ignoreCase), Utilities.lowerValue(r, ignoreCase), type, not);
    }

    private static Object lowerValue(Object o, boolean ignoreCase) {
        if (ignoreCase && (o = o.toString()) != null) {
            o = ((String)o).toLowerCase();
        }
        return o;
    }

    private static boolean compare2(Object l, Object r, int type, boolean not) {
        int c = Utilities.compare(l, r);
        if (type == 0 && c < 1) {
            return not;
        }
        if ((type == 1 || type == 4) && c < 0) {
            return not;
        }
        if (type == 2 && c > -1) {
            return not;
        }
        if ((type == 3 || type == 4) && c > 0) {
            return not;
        }
        return !not;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null || o2 == null) {
            return -1;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return Utilities.getDoubleObject(o1).compareTo(Utilities.getDoubleObject(o2));
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2);
    }

    public static boolean isGTEquals(Object o1, Object o2) {
        return Utilities.matches(o1, o2, false, 1, false);
    }

    public static boolean isLTEquals(Object o1, Object o2) {
        return Utilities.matches(o1, o2, false, 3, false);
    }

    public static boolean isEquals(Object o1, Object o2) {
        return Utilities.compare(o1, o2) == 0;
    }

    public static Double getDoubleObject(Object o) {
        return new Double(Utilities.getDouble(o));
    }

    public static double getDouble(Object o) {
        return ((Number)o).doubleValue();
    }

    public static boolean isNumber(Object o) {
        if (o == null) {
            return false;
        }
        return pCNames.containsKey(o.getClass().getName());
    }

    public static boolean isNumber(Class c) {
        return pCNames.containsKey(c.getName());
    }

    public static String formatSignature(String name, Class[] ps) {
        StringBuffer buf = new StringBuffer(name);
        buf.append("(");
        if (ps != null) {
            for (int i = 0; i < ps.length; ++i) {
                buf.append(ps[i].getName());
                if (i >= ps.length - 1) continue;
                buf.append(",");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static boolean matchLikePattern(List p, Object lhs, boolean not, boolean ignoreCase) {
        if (lhs instanceof Collection) {
            return Utilities.matchLikePattern(p, (Collection)lhs, not, ignoreCase);
        }
        boolean v = Utilities.matchLikePattern(p, lhs, ignoreCase);
        if (!v && not) {
            return true;
        }
        if (v && not) {
            return false;
        }
        return v;
    }

    public static boolean matchLikePattern(List p, Collection lhs, boolean not, boolean ignoreCase) {
        if (lhs instanceof List) {
            int s = lhs.size() - 1;
            List l = (List)lhs;
            for (int i = s; i > -1; --i) {
                Object o = l.get(i);
                if (Utilities.matchLikePattern(p, o, ignoreCase)) continue;
                return not;
            }
            return !not;
        }
        Iterator iter = lhs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (Utilities.matchLikePattern(p, o, ignoreCase)) continue;
            return not;
        }
        return !not;
    }

    public static boolean matchLikePattern(List p, Object o, boolean ignoreCase) {
        if (o == null) {
            return false;
        }
        String st = o.toString();
        if (ignoreCase) {
            st = st.toLowerCase();
        }
        return Utilities.matchLikePattern(p, st);
    }

    public static boolean matchLikePattern(List p, String value) {
        if (value == null) {
            return false;
        }
        boolean accept = true;
        String c = null;
        String pm = null;
        int currPos = 0;
        int s = p.size();
        for (int cmdPos = 0; cmdPos < s; cmdPos += 2) {
            int nextPos;
            c = (String)p.get(cmdPos);
            pm = (String)p.get(cmdPos + 1);
            if (c.equals(F)) {
                if (pm.equals(A)) break;
                nextPos = value.indexOf(pm, currPos);
                if (nextPos >= 0) {
                    currPos = nextPos + pm.length();
                    continue;
                }
                accept = false;
                break;
            }
            if (!c.equals(E)) continue;
            if (pm.equals(N)) {
                if (currPos == value.length()) break;
                accept = false;
                break;
            }
            nextPos = value.indexOf(pm, currPos);
            if (nextPos != currPos) {
                accept = false;
                break;
            }
            currPos += pm.length();
        }
        return accept;
    }

    public static boolean matchLikePattern(List p, String value, boolean not) {
        boolean accept = Utilities.matchLikePattern(p, value);
        if (not) {
            return !accept;
        }
        return accept;
    }

    public static List getLikePattern(String value, String wildcard) {
        ArrayList<String> p = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(value, wildcard, true);
        String tok = null;
        while (t.hasMoreTokens()) {
            tok = t.nextToken();
            if (tok.equals(wildcard)) {
                p.add(F);
                if (t.hasMoreTokens()) {
                    tok = t.nextToken();
                    p.add(tok);
                    continue;
                }
                p.add(A);
                continue;
            }
            p.add(E);
            p.add(tok);
        }
        if (tok == null || !tok.equals(wildcard)) {
            p.add(E);
            p.add(N);
        }
        return p;
    }

    public static String stripQuotes(String s) {
        if (s == null) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'' || s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static void getMethods(Class c, String name, int mods, List ms) {
        if (c == null) {
            return;
        }
        Method[] meths = c.getDeclaredMethods();
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().equals(name) || (m.getModifiers() & mods) != mods || ms.contains(m)) continue;
            ms.add(m);
        }
        Class sup = c.getSuperclass();
        if (sup != null) {
            Utilities.getMethods(sup, name, mods, ms);
        }
        Class<?>[] ints = c.getInterfaces();
        for (int i = 0; i < ints.length; ++i) {
            Class<?> in = ints[i];
            Utilities.getMethods(in, name, mods, ms);
        }
    }

    public static int matchMethodArgs(Class[] args, Class[] compArgs) {
        if (compArgs == null && args == null) {
            return 2;
        }
        if (compArgs == null && args.length == 0) {
            return 2;
        }
        if (compArgs == null && args.length > 0) {
            return 0;
        }
        if (args.length != compArgs.length) {
            return 0;
        }
        int score = 0;
        for (int i = 0; i < args.length; ++i) {
            Class c = args[i];
            if (c.getClass().getName().equals((class$java$lang$Object == null ? Utilities.class$("java.lang.Object") : class$java$lang$Object).getName())) {
                ++score;
                continue;
            }
            Class cc = compArgs[i];
            if (cc == null) continue;
            if (c.isAssignableFrom(cc)) {
                score += 2;
                continue;
            }
            if (Utilities.isNumber(cc) && Utilities.isNumber(c)) {
                ++score;
                continue;
            }
            if (Utilities.isPrimitiveClass(c) && Utilities.isPrimitiveClass(cc) && Utilities.getPrimitiveClass(c).isAssignableFrom(Utilities.getPrimitiveClass(cc))) {
                ++score;
                continue;
            }
            if (cc.getName().equals((class$java$lang$Object == null ? Utilities.class$("java.lang.Object") : class$java$lang$Object).getName())) {
                ++score;
                continue;
            }
            return 0;
        }
        return score;
    }

    public static Object[] convertArgs(Object[] args, Class[] argTypes) {
        if (args == null) {
            return args;
        }
        Object[] nargs = new Object[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            if (Utilities.isNumber(argTypes[i])) {
                Class c = Utilities.getObjectClass(argTypes[i]);
                Number arg = (Number)args[i];
                if ((class$java$lang$Double == null ? Utilities.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(c)) {
                    nargs[i] = arg;
                    continue;
                }
                if ((class$java$lang$Short == null ? Utilities.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(c)) {
                    nargs[i] = new Short(arg.shortValue());
                    continue;
                }
                if ((class$java$lang$Integer == null ? Utilities.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(c)) {
                    nargs[i] = new Integer(arg.intValue());
                    continue;
                }
                if ((class$java$lang$Long == null ? Utilities.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(c)) {
                    nargs[i] = new Long(arg.longValue());
                    continue;
                }
                if ((class$java$lang$Float == null ? Utilities.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(c)) {
                    nargs[i] = new Float(arg.floatValue());
                    continue;
                }
                if (!(class$java$lang$Byte == null ? Utilities.class$("java.lang.Byte") : class$java$lang$Byte).isAssignableFrom(c)) continue;
                nargs[i] = new Byte(arg.byteValue());
                continue;
            }
            nargs[i] = args[i];
        }
        return nargs;
    }

    static {
        pCNames.put("double", "");
        pCNames.put(Double.class.getName(), "");
        pCNames.put("int", "");
        pCNames.put(Integer.class.getName(), "");
        pCNames.put("float", "");
        pCNames.put(Float.class.getName(), "");
        pCNames.put("long", "");
        pCNames.put(Long.class.getName(), "");
        pCNames.put("short", "");
        pCNames.put(Short.class.getName(), "");
        pCNames.put("byte", "");
        pCNames.put(Byte.class.getName(), "");
        pCNames.put(Number.class.getName(), "");
        primNames.put(Double.TYPE.getName(), Double.class.getName());
        primNames.put(Double.class.getName(), Double.TYPE.getName());
        primNames.put(Integer.TYPE.getName(), Integer.class.getName());
        primNames.put(Integer.class.getName(), Integer.TYPE.getName());
        primNames.put(Float.TYPE.getName(), Float.class.getName());
        primNames.put(Float.class.getName(), Float.TYPE.getName());
        primNames.put(Long.TYPE.getName(), Long.class.getName());
        primNames.put(Long.class.getName(), Long.TYPE.getName());
        primNames.put(Short.TYPE.getName(), Short.class.getName());
        primNames.put(Short.class.getName(), Short.TYPE.getName());
        primNames.put(Byte.TYPE.getName(), Byte.class.getName());
        primNames.put(Byte.class.getName(), Byte.TYPE.getName());
        primNames.put(Character.TYPE.getName(), Character.class.getName());
        primNames.put(Character.class.getName(), Character.TYPE.getName());
        primNames.put(Boolean.TYPE.getName(), Boolean.class.getName());
        primNames.put(Boolean.class.getName(), Boolean.TYPE.getName());
        primCls.put(Double.TYPE.getName(), Double.TYPE);
        primCls.put(Double.class.getName(), Double.TYPE);
        primCls.put(Integer.TYPE.getName(), Integer.TYPE);
        primCls.put(Integer.class.getName(), Integer.TYPE);
        primCls.put(Float.TYPE.getName(), Float.TYPE);
        primCls.put(Float.class.getName(), Float.TYPE);
        primCls.put(Long.TYPE.getName(), Long.TYPE);
        primCls.put(Long.class.getName(), Long.TYPE);
        primCls.put(Short.TYPE.getName(), Short.TYPE);
        primCls.put(Short.class.getName(), Short.TYPE);
        primCls.put(Byte.TYPE.getName(), Byte.TYPE);
        primCls.put(Byte.class.getName(), Byte.TYPE);
        primCls.put(Character.TYPE.getName(), Character.TYPE);
        primCls.put(Character.class.getName(), Character.TYPE);
        primCls.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primCls.put(Boolean.class.getName(), Boolean.TYPE);
    }
}

