/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public class ChunkedWriter
extends Writer {
    private final OutputStream out;
    private final CharsetEncoder encoder;
    private final ByteBuffer bb;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private CharBuffer lcb = null;
    private static final byte[] EMPTY = new byte[0];
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 4096;
    private volatile boolean isOpen = true;

    public ChunkedWriter(OutputStream stream, String charset) {
        super(stream);
        this.out = stream;
        if (!Charset.isSupported(charset)) {
            throw new UnsupportedCharsetException(charset);
        }
        Charset cs = Charset.forName(charset);
        this.encoder = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.bb = ByteBuffer.allocate(4096);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.implWrite(cbuf, off, len);
        }
    }

    @Override
    public void write(int c) throws IOException {
        char[] cbuf = new char[]{(char)c};
        this.write(cbuf, 0, 1);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cbuf = new char[len];
        str.getChars(off, off + len, cbuf, 0);
        this.write(cbuf, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.implFlush();
        }
    }

    void implFlushBuffer() throws IOException {
        if (this.bb.position() > 0) {
            this.writeBytes();
        }
        this.flushLeftOverChar(null, true);
        try {
            CoderResult cr;
            while (!(cr = this.encoder.flush(this.bb)).isUnderflow()) {
                if (cr.isOverflow()) {
                    assert (this.bb.position() > 0);
                    this.writeBytes();
                    continue;
                }
                cr.throwException();
            }
            if (this.bb.position() > 0) {
                this.writeBytes();
            }
        }
        catch (IOException x) {
            this.encoder.reset();
            throw x;
        }
        this.out.write(EMPTY);
    }

    void implFlush() throws IOException {
        this.implFlushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.out.close();
            this.isOpen = false;
        }
    }

    void implWrite(char[] cbuf, int off, int len) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
        if (this.haveLeftoverChar) {
            this.flushLeftOverChar(cb, false);
        }
        while (cb.hasRemaining()) {
            CoderResult cr = this.encoder.encode(cb, this.bb, false);
            if (cr.isUnderflow()) {
                assert (cb.remaining() <= 1) : cb.remaining();
                if (cb.remaining() != 1) break;
                this.haveLeftoverChar = true;
                this.leftoverChar = cb.get();
                break;
            }
            if (cr.isOverflow()) {
                assert (this.bb.position() > 0);
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
    }

    private void flushLeftOverChar(CharBuffer cb, boolean endOfInput) throws IOException {
        if (!this.haveLeftoverChar && !endOfInput) {
            return;
        }
        if (this.lcb == null) {
            this.lcb = CharBuffer.allocate(2);
        } else {
            this.lcb.clear();
        }
        if (this.haveLeftoverChar) {
            this.lcb.put(this.leftoverChar);
        }
        if (cb != null && cb.hasRemaining()) {
            this.lcb.put(cb.get());
        }
        this.lcb.flip();
        while (this.lcb.hasRemaining() || endOfInput) {
            CoderResult cr = this.encoder.encode(this.lcb, this.bb, endOfInput);
            if (cr.isUnderflow()) {
                if (!this.lcb.hasRemaining()) break;
                this.leftoverChar = this.lcb.get();
                if (cb != null && cb.hasRemaining()) {
                    this.flushLeftOverChar(cb, endOfInput);
                }
                return;
            }
            if (cr.isOverflow()) {
                assert (this.bb.position() > 0);
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
        this.haveLeftoverChar = false;
    }

    private void writeBytes() throws IOException {
        this.bb.flip();
        int lim = this.bb.limit();
        int pos = this.bb.position();
        assert (pos <= lim);
        int rem = lim - pos;
        if (rem > 0) {
            this.out.write(this.bb.array(), this.bb.arrayOffset() + pos, rem);
        }
        this.bb.clear();
    }
}

