/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;

public class UpdateBatchQuery
extends BatchQuery {
    protected boolean usingOptimisticLocking;
    private List<DbAttribute> updatedAttributes;
    private List<DbAttribute> qualifierAttributes;
    private Collection<String> nullQualifierNames;

    private static List<DbAttribute> toDbAttributes(List<DbAttribute> qualifierAttributes, List<DbAttribute> updatedAttributes) {
        ArrayList<DbAttribute> dbAttributes = new ArrayList<DbAttribute>(updatedAttributes.size() + qualifierAttributes.size());
        dbAttributes.addAll(updatedAttributes);
        dbAttributes.addAll(qualifierAttributes);
        return dbAttributes;
    }

    public UpdateBatchQuery(DbEntity dbEntity, List<DbAttribute> qualifierAttributes, List<DbAttribute> updatedAttributes, Collection<String> nullQualifierNames, int batchCapacity) {
        super(dbEntity, UpdateBatchQuery.toDbAttributes(qualifierAttributes, updatedAttributes), batchCapacity);
        if (nullQualifierNames == null) {
            throw new NullPointerException("Null 'nullQualifierNames'");
        }
        this.updatedAttributes = updatedAttributes;
        this.qualifierAttributes = qualifierAttributes;
        this.nullQualifierNames = nullQualifierNames;
    }

    public boolean isNull(DbAttribute attribute) {
        return this.nullQualifierNames.contains(attribute.getName());
    }

    @Override
    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    public void setUsingOptimisticLocking(boolean usingOptimisticLocking) {
        this.usingOptimisticLocking = usingOptimisticLocking;
    }

    public void add(Map<String, Object> qualifierSnapshot, Map<String, Object> updateSnapshot) {
        this.add(qualifierSnapshot, updateSnapshot, null);
    }

    public void add(Map<String, Object> qualifierSnapshot, final Map<String, Object> updateSnapshot, ObjectId id) {
        this.rows.add(new BatchQueryRow(id, qualifierSnapshot){

            @Override
            public Object getValue(int i) {
                Map snapshot = i < UpdateBatchQuery.this.updatedAttributes.size() ? updateSnapshot : this.qualifier;
                return this.getValue(snapshot, (DbAttribute)UpdateBatchQuery.this.dbAttributes.get(i));
            }
        });
    }

    @Override
    public List<DbAttribute> getDbAttributes() {
        return this.dbAttributes;
    }

    public List<DbAttribute> getUpdatedAttributes() {
        return Collections.unmodifiableList(this.updatedAttributes);
    }

    public List<DbAttribute> getQualifierAttributes() {
        return Collections.unmodifiableList(this.qualifierAttributes);
    }
}

