/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog.meta;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.commitlog.meta.CommitLogEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

public class MutableCommitLogLogEntity
implements CommitLogEntity {
    private Collection<String> ignoredProperties;
    private Collection<String> confidentialProperties;
    private ObjEntity entity;

    public MutableCommitLogLogEntity(ObjEntity entity) {
        this.entity = entity;
        this.ignoredProperties = new HashSet<String>();
        this.confidentialProperties = new HashSet<String>();
    }

    @Override
    public boolean isIncluded(String property) {
        return !this.ignoredProperties.contains(property);
    }

    @Override
    public boolean isIncluded() {
        return true;
    }

    @Override
    public boolean isConfidential(String property) {
        return this.confidentialProperties.contains(property);
    }

    MutableCommitLogLogEntity setConfidential(String[] confidentialProperties) {
        if (confidentialProperties != null) {
            for (String property : confidentialProperties) {
                this.confidentialProperties.add(property);
            }
        }
        return this;
    }

    MutableCommitLogLogEntity setIgnoreProperties(String[] properties) {
        if (properties != null) {
            for (String property : properties) {
                this.ignoredProperties.add(property);
            }
        }
        return this;
    }

    MutableCommitLogLogEntity setIgnoreAttributes(boolean ignore) {
        if (ignore) {
            for (ObjAttribute a : this.entity.getAttributes()) {
                this.ignoredProperties.add(a.getName());
            }
        }
        return this;
    }

    MutableCommitLogLogEntity setIgnoreToOneRelationships(boolean ignore) {
        if (ignore) {
            for (ObjRelationship r : this.entity.getRelationships()) {
                if (r.isToMany()) continue;
                this.ignoredProperties.add(r.getName());
            }
        }
        return this;
    }

    MutableCommitLogLogEntity setIgnoreToManyRelationships(boolean ignore) {
        if (ignore) {
            for (ObjRelationship r : this.entity.getRelationships()) {
                if (!r.isToMany()) continue;
                this.ignoredProperties.add(r.getName());
            }
        }
        return this;
    }
}

