/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.TableTreeNode;
import org.apache.cayenne.access.translator.select.TableTreeStage;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;

class TableTreeQualifierStage
implements TranslationStage {
    TableTreeQualifierStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        context.getTableTree().visit(node -> {
            if (node.getRelationship() == null) {
                TableTreeQualifierStage.appendQualifier(context, node, node.getEntity().getQualifier());
                TableTreeQualifierStage.appendQualifier(context, node, node.getAdditionalQualifier());
            }
        });
        if (context.getQualifierNode() != null) {
            context.getSelectBuilder().where(context.getQualifierNode());
        }
    }

    private static void appendQualifier(TranslatorContext context, TableTreeNode node, Expression dbQualifier) {
        if (dbQualifier == null) {
            return;
        }
        dbQualifier = TableTreeStage.translateToDbPath(node, dbQualifier);
        Node translatedQualifier = context.getQualifierTranslator().translate(dbQualifier);
        context.appendQualifierNode(translatedQualifier);
    }
}

