/*
 * Decompiled with CFR 0.152.
 */
package com.werken.forehead;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ForeheadClassLoader
extends URLClassLoader {
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private String name;

    public ForeheadClassLoader(ClassLoader parent, String name) {
        super(EMPTY_URL_ARRAY, parent);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return "[ForeheadClassLoader: name=\"" + this.getName() + "\"]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceAsString(String name) {
        StringWriter sw = null;
        BufferedReader reader = null;
        try {
            sw = new StringWriter();
            InputStream is = ((ClassLoader)this).getResourceAsStream(name);
            reader = new BufferedReader(new InputStreamReader(is));
            char[] buf = new char[1024];
            int len = 0;
            while ((len = reader.read(buf, 0, 1024)) != -1) {
                sw.write(buf, 0, len);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            try {
                sw.close();
                reader.close();
            }
            catch (Exception ignored) {}
        }
    }

    public void addRepository(String repository) {
        this.addRepository(new File(repository));
    }

    public void addRepository(File repository) {
        if (repository.exists() && repository.isDirectory()) {
            File[] jars = repository.listFiles();
            for (int j = 0; j < jars.length; ++j) {
                if (!jars[j].getAbsolutePath().endsWith(".jar")) continue;
                try {
                    URL url = jars[j].toURL();
                    super.addURL(url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
        }
    }
}

