/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.WildcardFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WildcardFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*.txt");
        list.add("*.a??");
        WildcardFileFilter filter = new WildcardFileFilter(list);
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*.txt");
        list.add("*.a??");
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.INSENSITIVE, list);
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*.txt");
        list.add("*.a??");
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.SENSITIVE, list);
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() {
        WildcardFileFilter filter = new WildcardFileFilter(new String[]{"*.txt", "*.a??"});
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() {
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.INSENSITIVE, new String[]{"*.txt", "*.a??"});
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() {
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.SENSITIVE, new String[]{"*.txt", "*.a??"});
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assertions.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assertions.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

