/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tdigest;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.tdigest.TDigestDouble;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TDigestCrossLanguageTest {
    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppDouble() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("tdigest_double_n" + n + "_cpp.sk"));
            TDigestDouble td = TDigestDouble.heapify((MemorySegment)MemorySegment.ofArray(bytes));
            Assert.assertTrue((boolean)(n == 0 ? td.isEmpty() : !td.isEmpty()));
            Assert.assertEquals((long)td.getTotalWeight(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((double)td.getMinValue(), (double)1.0);
            Assert.assertEquals((double)td.getMaxValue(), (double)n);
            Assert.assertEquals((double)td.getRank(0.0), (double)0.0);
            Assert.assertEquals((double)td.getRank((double)(n + 1)), (double)1.0);
            if (n == 1) {
                Assert.assertEquals((double)td.getRank((double)n), (double)0.5);
                continue;
            }
            Assert.assertEquals((double)td.getRank((double)(n / 2)), (double)0.5, (double)0.05);
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppFloat() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("tdigest_float_n" + n + "_cpp.sk"));
            TDigestDouble td = TDigestDouble.heapify((MemorySegment)MemorySegment.ofArray(bytes), (boolean)true);
            Assert.assertTrue((boolean)(n == 0 ? td.isEmpty() : !td.isEmpty()));
            Assert.assertEquals((long)td.getTotalWeight(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((double)td.getMinValue(), (double)1.0);
            Assert.assertEquals((double)td.getMaxValue(), (double)n);
            Assert.assertEquals((double)td.getRank(0.0), (double)0.0);
            Assert.assertEquals((double)td.getRank((double)(n + 1)), (double)1.0);
            if (n == 1) {
                Assert.assertEquals((double)td.getRank((double)n), (double)0.5);
                continue;
            }
            Assert.assertEquals((double)td.getRank((double)(n / 2)), (double)0.5, (double)0.05);
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateForCppDouble() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            TDigestDouble td = new TDigestDouble(100);
            for (int i = 1; i <= n; ++i) {
                td.update((double)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("tdigest_double_n" + n + "_java.sk"), new OpenOption[0]).write(td.toByteArray());
        }
    }
}

