/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchTest {
    @Test
    public void checkGetMaxBytesWithEntries() {
        Assert.assertEquals((int)ThetaSketch.getMaxCompactSketchBytes((int)10), (int)(80 + (Family.COMPACT.getMaxPreLongs() << 3)));
    }

    @Test
    public void checkGetCurrentBytes() {
        int i;
        int k = 64;
        int lowQSPreLongs = Family.QUICKSELECT.getMinPreLongs();
        int lowCompPreLongs = Family.COMPACT.getMinPreLongs();
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(64).build();
        Assert.assertEquals((int)sketch.getCurrentPreambleLongs(), (int)lowQSPreLongs);
        Assert.assertEquals((int)sketch.getCompactPreambleLongs(), (int)1);
        Assert.assertEquals((int)sketch.getCurrentDataLongs(), (int)128);
        Assert.assertEquals((int)sketch.getCurrentBytes(), (int)(1024 + (lowQSPreLongs << 3)));
        Assert.assertEquals((int)sketch.getCompactBytes(), (int)(lowCompPreLongs << 3));
        CompactThetaSketch compSk = sketch.compact(false, null);
        Assert.assertEquals((int)compSk.getCompactBytes(), (int)8);
        Assert.assertEquals((int)compSk.getCurrentBytes(), (int)8);
        Assert.assertEquals((int)compSk.getCurrentDataLongs(), (int)0);
        int compPreLongs = CompactOperations.computeCompactPreLongs((boolean)sketch.isEmpty(), (int)sketch.getRetainedEntries(true), (long)sketch.getThetaLong());
        Assert.assertEquals((int)compPreLongs, (int)1);
        for (i = 0; i < 64; ++i) {
            sketch.update((long)i);
        }
        Assert.assertEquals((int)sketch.getCurrentPreambleLongs(), (int)lowQSPreLongs);
        Assert.assertEquals((int)sketch.getCompactPreambleLongs(), (int)2);
        Assert.assertEquals((int)sketch.getCurrentDataLongs(), (int)128);
        Assert.assertEquals((int)sketch.getCurrentBytes(), (int)(1024 + (lowQSPreLongs << 3)));
        Assert.assertEquals((int)sketch.getCompactBytes(), (int)528);
        compPreLongs = CompactOperations.computeCompactPreLongs((boolean)sketch.isEmpty(), (int)sketch.getRetainedEntries(true), (long)sketch.getThetaLong());
        Assert.assertEquals((int)compPreLongs, (int)2);
        for (i = 64; i < 128; ++i) {
            sketch.update((long)i);
        }
        int curCount = sketch.getRetainedEntries(true);
        Assert.assertEquals((int)sketch.getCurrentPreambleLongs(), (int)lowQSPreLongs);
        Assert.assertEquals((int)sketch.getCompactPreambleLongs(), (int)3);
        Assert.assertEquals((int)sketch.getCurrentDataLongs(), (int)128);
        Assert.assertEquals((int)sketch.getCurrentBytes(), (int)(1024 + (lowQSPreLongs << 3)));
        Assert.assertEquals((int)sketch.getCompactBytes(), (int)(curCount * 8 + 24));
        compPreLongs = CompactOperations.computeCompactPreLongs((boolean)sketch.isEmpty(), (int)sketch.getRetainedEntries(true), (long)sketch.getThetaLong());
        Assert.assertEquals((int)compPreLongs, (int)3);
        for (int i2 = 0; i2 < 3; ++i2) {
            int maxCompBytes = ThetaSketch.getMaxCompactSketchBytes((int)i2);
            if (i2 == 0) {
                Assert.assertEquals((int)maxCompBytes, (int)8);
            }
            if (i2 == 1) {
                Assert.assertEquals((int)maxCompBytes, (int)16);
            }
            if (i2 <= 1) continue;
            Assert.assertEquals((int)maxCompBytes, (int)(24 + i2 * 8));
        }
    }

    @Test
    public void checkBuilder() {
        int k = 2048;
        int lgK = Integer.numberOfTrailingZeros(2048);
        long seed = 1021L;
        float p = 0.5f;
        ResizeFactor rf = ResizeFactor.X4;
        Family fam = Family.ALPHA;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setSeed(1021L).setP(0.5f).setResizeFactor(rf).setFamily(fam).setNominalEntries(2048).build();
        String nameS1 = sk1.getClass().getSimpleName();
        Assert.assertEquals((String)nameS1, (String)"HeapAlphaSketch");
        Assert.assertEquals((int)sk1.getLgNomLongs(), (int)lgK);
        Assert.assertEquals((long)sk1.getSeed(), (long)1021L);
        Assert.assertEquals((float)sk1.getP(), (float)0.5f);
        sk1 = UpdatableThetaSketch.builder().build();
        nameS1 = sk1.getClass().getSimpleName();
        Assert.assertEquals((String)nameS1, (String)"HeapQuickSelectSketch");
        Assert.assertEquals((int)sk1.getLgNomLongs(), (int)Integer.numberOfTrailingZeros(4096));
        Assert.assertEquals((long)sk1.getSeed(), (long)9001L);
        Assert.assertEquals((float)sk1.getP(), (float)1.0f);
        Assert.assertEquals((Object)sk1.getResizeFactor(), (Object)ResizeFactor.X8);
    }

    @Test
    public void checkBuilderNonPowerOf2() {
        int k = 1000;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setNominalEntries(1000).build();
        Assert.assertEquals((int)sk.getLgNomLongs(), (int)10);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderIllegalP() {
        float p = 1.5f;
        UpdatableThetaSketch.builder().setP(1.5f).build();
    }

    @Test
    public void checkBuilderResizeFactor() {
        ResizeFactor rf = ResizeFactor.X1;
        Assert.assertEquals((int)rf.getValue(), (int)1);
        Assert.assertEquals((int)rf.lg(), (int)0);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)0), (Object)ResizeFactor.X1);
        rf = ResizeFactor.X2;
        Assert.assertEquals((int)rf.getValue(), (int)2);
        Assert.assertEquals((int)rf.lg(), (int)1);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)1), (Object)ResizeFactor.X2);
        rf = ResizeFactor.X4;
        Assert.assertEquals((int)rf.getValue(), (int)4);
        Assert.assertEquals((int)rf.lg(), (int)2);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)2), (Object)ResizeFactor.X4);
        rf = ResizeFactor.X8;
        Assert.assertEquals((int)rf.getValue(), (int)8);
        Assert.assertEquals((int)rf.lg(), (int)3);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)3), (Object)ResizeFactor.X8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapBadFamily() {
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(1024).build();
        byte[] byteArr = sketch.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArr);
        ThetaSketch.wrap((MemorySegment)srcSeg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        UpdatableThetaSketch.builder().setFamily(Family.INTERSECTION).setNominalEntries(1024).build();
    }

    @Test
    public void checkSerVer() {
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        byte[] sketchArray = sketch.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(sketchArray);
        int serVer = ThetaSketch.getSerializationVersion((MemorySegment)seg);
        Assert.assertEquals((int)serVer, (int)3);
        MemorySegment wseg = MemorySegment.ofArray(sketchArray);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.wrap((MemorySegment)wseg);
        serVer = UpdatableThetaSketch.getSerializationVersion((MemorySegment)wseg);
        Assert.assertEquals((int)serVer, (int)3);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyAlphaCompactExcep() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(512).build();
        byte[] byteArray = sketch1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        Util.setBits((MemorySegment)seg, (long)5L, (byte)8);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyQSCompactExcep() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(512).build();
        byte[] byteArray = sketch1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        Util.setBits((MemorySegment)seg, (long)5L, (byte)8);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyNotCompactExcep() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(512).build();
        int bytes = ThetaSketch.getMaxCompactSketchBytes((int)0);
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        sketch1.compact(false, seg);
        Util.clearBits((MemorySegment)seg, (long)5L, (byte)8);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyFamilyExcep() {
        int k = 512;
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(512).buildUnion();
        byte[] byteArray = union.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapAlphaCompactExcep() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(512).build();
        byte[] byteArray = sketch1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        Util.setBits((MemorySegment)seg, (long)5L, (byte)8);
        ThetaSketch.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapQSCompactExcep() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(512).build();
        byte[] byteArray = sketch1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        Util.setBits((MemorySegment)seg, (long)5L, (byte)8);
        ThetaSketch.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapNotCompactExcep() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(512).build();
        int bytes = ThetaSketch.getMaxCompactSketchBytes((int)0);
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        sketch1.compact(false, seg);
        Util.clearBits((MemorySegment)seg, (long)5L, (byte)8);
        ThetaSketch.wrap((MemorySegment)seg);
    }

    @Test
    public void checkValidSketchID() {
        Assert.assertFalse((boolean)ThetaSketch.isValidSketchID((int)0));
        Assert.assertTrue((boolean)ThetaSketch.isValidSketchID((int)Family.ALPHA.getID()));
        Assert.assertTrue((boolean)ThetaSketch.isValidSketchID((int)Family.QUICKSELECT.getID()));
        Assert.assertTrue((boolean)ThetaSketch.isValidSketchID((int)Family.COMPACT.getID()));
    }

    @Test
    public void checkIsSameResource() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        MemorySegment cseg = MemorySegment.ofArray(new byte[32]);
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16).build(seg);
        sketch.update(1L);
        sketch.update(2L);
        Assert.assertTrue((boolean)sketch.isSameResource(seg));
        DirectCompactSketch dcos = (DirectCompactSketch)sketch.compact(true, cseg);
        Assert.assertTrue((boolean)MemorySegmentStatus.isSameResource((MemorySegment)dcos.getMemorySegment(), (MemorySegment)cseg));
        Assert.assertTrue((boolean)dcos.isOrdered());
        DirectCompactSketch dcs = (DirectCompactSketch)sketch.compact(false, cseg);
        Assert.assertTrue((boolean)MemorySegmentStatus.isSameResource((MemorySegment)dcs.getMemorySegment(), (MemorySegment)cseg));
        Assert.assertFalse((boolean)dcs.isOrdered());
    }

    @Test
    public void checkCountLessThanTheta() {
        int k = 512;
        UpdatableThetaSketch sketch1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sketch1.update((long)i);
        }
        double theta = sketch1.rebuild().getTheta();
        long thetaLong = (long)(9.223372036854776E18 * theta);
        int count = sketch1.getCountLessThanThetaLong(thetaLong);
        Assert.assertEquals((int)count, (int)512);
    }

    private static MemorySegment createCompactSketchMemorySegment(int k, int u) {
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = ThetaSketch.getMaxCompactSketchBytes((int)usk.getRetainedEntries(true));
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        usk.compact(true, wseg);
        return wseg;
    }

    @Test
    public void checkCompactFlagsOnWrap() {
        MemorySegment wseg = SketchTest.createCompactSketchMemorySegment(16, 32);
        ThetaSketch sk = ThetaSketch.wrap((MemorySegment)wseg);
        Assert.assertTrue((boolean)(sk instanceof CompactThetaSketch));
        int flags = PreambleUtil.extractFlags((MemorySegment)wseg);
        int flagsNoCompact = flags & 0xFFFFFFF7;
        PreambleUtil.insertFlags((MemorySegment)wseg, (int)flagsNoCompact);
        try {
            sk = ThetaSketch.wrap((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        int flagsNoReadOnly = flags & 0xFFFFFFFD;
        PreambleUtil.insertFlags((MemorySegment)wseg, (int)flagsNoReadOnly);
        try {
            sk = ThetaSketch.wrap((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertFlags((MemorySegment)wseg, (int)flags);
        PreambleUtil.insertSerVer((MemorySegment)wseg, (int)5);
        try {
            sk = ThetaSketch.wrap((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCompactSizeAndFlagsOnHeapify() {
        MemorySegment wseg = SketchTest.createCompactSketchMemorySegment(16, 32);
        ThetaSketch sk = ThetaSketch.heapify((MemorySegment)wseg);
        Assert.assertTrue((boolean)(sk instanceof CompactThetaSketch));
        int flags = PreambleUtil.extractFlags((MemorySegment)wseg);
        int flagsNoCompact = flags & 0xFFFFFFFD;
        PreambleUtil.insertFlags((MemorySegment)wseg, (int)flagsNoCompact);
        try {
            sk = ThetaSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        wseg = MemorySegment.ofArray(new byte[7]);
        PreambleUtil.insertSerVer((MemorySegment)wseg, (int)3);
        try {
            sk = ThetaSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void check2Methods() {
        int k = 16;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        int bytes1 = sk.getCompactBytes();
        int bytes2 = sk.getCurrentBytes();
        Assert.assertEquals((int)bytes1, (int)8);
        Assert.assertEquals((int)bytes2, (int)280);
        int retEnt = sk.getRetainedEntries();
        Assert.assertEquals((int)retEnt, (int)0);
    }

    @Test
    public void printlnTest() {
        SketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

