/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;

final class IntMemorySegmentPairIterator
extends PairIterator {
    private final MemorySegment seg;
    private final long offsetBytes;
    private final int arrLen;
    private final int slotMask;
    private int index;
    private int pair;

    IntMemorySegmentPairIterator(MemorySegment seg, long offsetBytes, int arrayLength, int lgConfigK) {
        this.seg = seg;
        this.offsetBytes = offsetBytes;
        this.arrLen = arrayLength;
        this.slotMask = (1 << lgConfigK) - 1;
        this.index = -1;
    }

    IntMemorySegmentPairIterator(byte[] byteArr, long offsetBytes, int lengthPairs, int lgConfigK) {
        this(MemorySegment.ofArray(byteArr), offsetBytes, lengthPairs, lgConfigK);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getKey() {
        return HllUtil.getPairLow26(this.pair);
    }

    @Override
    public int getPair() {
        return this.pair;
    }

    @Override
    public int getSlot() {
        return this.getKey() & this.slotMask;
    }

    @Override
    public int getValue() {
        return HllUtil.getPairValue(this.pair);
    }

    @Override
    public boolean nextAll() {
        if (++this.index < this.arrLen) {
            this.pair = this.pair();
            return true;
        }
        return false;
    }

    @Override
    public boolean nextValid() {
        while (++this.index < this.arrLen) {
            int pair = this.pair();
            if (pair == 0) continue;
            this.pair = pair;
            return true;
        }
        return false;
    }

    int pair() {
        return this.seg.get(ValueLayout.JAVA_INT_UNALIGNED, this.offsetBytes + (long)(this.index << 2));
    }
}

