/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;

public class QuantilesDoublesSketchBuilder {
    private int bK = 128;

    public QuantilesDoublesSketchBuilder setK(int k) {
        ClassicUtil.checkK(k);
        this.bK = k;
        return this;
    }

    public int getK() {
        return this.bK;
    }

    public UpdatableQuantilesDoublesSketch build() {
        return HeapUpdateDoublesSketch.newInstance(this.bK);
    }

    public UpdatableQuantilesDoublesSketch build(MemorySegment dstSeg) {
        return this.build(dstSeg, null);
    }

    public UpdatableQuantilesDoublesSketch build(MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        return DirectUpdateDoublesSketch.newInstance(this.bK, dstSeg, mSegReq);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuantileSketchBuilder configuration:").append(Util.LS);
        sb.append("K     : ").append('\t').append(this.bK).append(Util.LS);
        return sb.toString();
    }
}

