/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;

public class RoutinePermsDescriptor
extends PermissionsDescriptor {
    private UUID routineUUID;
    private String routineName;
    private boolean hasExecutePermission;

    public RoutinePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID routineUUID, boolean hasExecutePermission) throws StandardException {
        super(dd, grantee, grantor);
        this.routineUUID = routineUUID;
        this.hasExecutePermission = hasExecutePermission;
        if (routineUUID != null) {
            this.routineName = dd.getAliasDescriptor(routineUUID).getObjectName();
        }
    }

    public RoutinePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID routineUUID) throws StandardException {
        this(dd, grantee, grantor, routineUUID, true);
    }

    public RoutinePermsDescriptor(DataDictionary dd, String grantee, String grantor) throws StandardException {
        this(dd, grantee, grantor, null);
    }

    public RoutinePermsDescriptor(DataDictionary dd, UUID routineePermsUUID) throws StandardException {
        this(dd, null, null, null, true);
        this.oid = routineePermsUUID;
    }

    @Override
    public int getCatalogNumber() {
        return 18;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    public boolean getHasExecutePermission() {
        return this.hasExecutePermission;
    }

    public String toString() {
        return "routinePerms: grantee=" + this.getGrantee() + ",routinePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",routineUUID=" + this.getRoutineUUID();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RoutinePermsDescriptor)) {
            return false;
        }
        RoutinePermsDescriptor otherRoutinePerms = (RoutinePermsDescriptor)other;
        return super.keyEquals(otherRoutinePerms) && this.routineUUID.equals(otherRoutinePerms.routineUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.routineUUID.hashCode();
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        UUID sd = this.getDataDictionary().getAliasDescriptor(this.routineUUID).getSchemaUUID();
        return this.getDataDictionary().getSchemaDescriptor(sd, null).getAuthorizationId().equals(authorizationId);
    }

    @Override
    public String getObjectName() {
        return "Routine Privilege on " + this.routineName;
    }

    @Override
    public String getClassType() {
        return "RoutinePrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(461);
    }
}

