/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.demo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import toursdb.insertMaps;

public class CheckToursDBTest
extends BaseJDBCTestCase {
    public CheckToursDBTest(String string) {
        super(string);
    }

    public static Test basesuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(CheckToursDBTest.class, string);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/demo/cupisle.gif", "functionTests/tests/demo/smallisle.gif", "functionTests/tests/demo/witchisle.gif"});
        return supportFilesSetup;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty CheckToursDBTest - *.setBigDecimal not supported with JSR169");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("CheckToursDBTest");
        baseTestSuite.addTest(CheckToursDBTest.basesuite("CheckToursDBTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(CheckToursDBTest.basesuite("CheckToursDBTest:client")));
        return baseTestSuite;
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("DROP TABLE AIRLINES");
        statement.execute("DROP TABLE CITIES");
        statement.execute("DROP TABLE COUNTRIES");
        statement.execute("DROP TABLE FLIGHTAVAILABILITY");
        statement.execute("DROP TABLE FLIGHTS");
        statement.execute("DROP TABLE MAPS");
        statement.execute("DROP TABLE FLIGHTS_HISTORY");
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testToursDB() throws Exception {
        String[] stringArray = new String[]{"ToursDB_schema.sql", "loadCOUNTRIES.sql", "loadCITIES.sql", "loadAIRLINES.sql", "loadFLIGHTS1.sql", "loadFLIGHTS2.sql", "loadFLIGHTAVAILABILITY1.sql", "loadFLIGHTAVAILABILITY2.sql"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.runScript("org/apache/derbyTesting/functionTests/tests/demo/" + stringArray[i], "US-ASCII");
        }
        this.insertMapsPrivileged();
        this.doSelect();
        this.doUpdate();
        this.doDelete();
    }

    private void doDelete() throws Exception {
        String[] stringArray = new String[]{"AIRLINES", "CITIES", "COUNTRIES", "FLIGHTAVAILABILITY", "FLIGHTS", "MAPS"};
        int[] nArray = new int[]{2, 87, 114, 518, 542, 3};
        PreparedStatement preparedStatement = null;
        for (int i = 0; i < 6; ++i) {
            preparedStatement = this.prepareStatement("delete from " + stringArray[i]);
            CheckToursDBTest.assertEquals((int)preparedStatement.executeUpdate(), (int)nArray[i]);
        }
        preparedStatement = this.prepareStatement("select STATUS from FLIGHTS_HISTORY where FLIGHT_ID IS NULL and STATUS <> 'over'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "INSERTED FROM TRIG2");
        preparedStatement = this.prepareStatement("delete from FLIGHTS_HISTORY");
        CheckToursDBTest.assertEquals((int)preparedStatement.executeUpdate(), (int)2);
    }

    private void doUpdate() throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareStatement("select ECONOMY_SEATS from AIRLINES where AIRLINE = 'AA'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "20");
        Statement statement = this.createStatement();
        statement.execute("update AIRLINES set ECONOMY_SEATS=108 where AIRLINE = 'AA'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "108");
        preparedStatement = this.prepareStatement("select COUNTRY from COUNTRIES where COUNTRY_ISO_CODE = 'US'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "United States");
        statement.execute("update COUNTRIES set COUNTRY='United States of America' where COUNTRY_ISO_CODE = 'US'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "United States of America");
        preparedStatement = this.prepareStatement("select COUNTRY from CITIES where CITY_ID = 52");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "United States");
        statement.execute("update CITIES set COUNTRY='United States of America' where COUNTRY='United States'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "United States of America");
        preparedStatement = this.prepareStatement("select ECONOMY_SEATS_TAKEN from FLIGHTAVAILABILITY where FLIGHT_ID = 'AA1134' and FLIGHT_DATE='2004-03-31'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "2");
        statement.execute("update FLIGHTAVAILABILITY set ECONOMY_SEATS_TAKEN=20 where FLIGHT_ID = 'AA1134' and FLIGHT_DATE='2004-03-31'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "20");
        preparedStatement = this.prepareStatement("select AIRCRAFT from FLIGHTS where FLIGHT_ID = 'AA1183'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "B747");
        statement.execute("update FLIGHTS set AIRCRAFT='B777' where FLIGHT_ID = 'AA1134'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "B747");
        preparedStatement = this.prepareStatement("select REGION from MAPS where MAP_NAME = 'North Ocean'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "Cup Island");
        statement.execute("update MAPS set REGION='Coffee Cup Island' where MAP_NAME = 'North Ocean'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "Coffee Cup Island");
        preparedStatement = this.prepareStatement("select STATUS from FLIGHTS_HISTORY where FLIGHT_ID = 'AA1134'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "INSERTED FROM TRIG1");
        statement.execute("update FLIGHTS_HISTORY set STATUS='over' where FLIGHT_ID='AA1134'");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "over");
    }

    public void insertMapsPrivileged() throws Exception {
        this.insertMaps();
    }

    private void doSelect() throws SQLException {
        String[] stringArray = new String[]{"2", "114", "87", "518", "542", "3", "0"};
        PreparedStatement preparedStatement = null;
        String[] stringArray2 = new String[]{"AIRLINES", "COUNTRIES", "CITIES", "FLIGHTAVAILABILITY", "FLIGHTS", "MAPS", "FLIGHTS_HISTORY"};
        for (int i = 0; i < 7; ++i) {
            preparedStatement = this.prepareStatement("select count(*) from " + stringArray2[i]);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), stringArray[i]);
        }
    }

    private void insertMaps() throws SQLException, FileNotFoundException, IOException {
        Connection connection = this.getConnection();
        CheckToursDBTest.assertEquals((int)insertMaps.insertRows("extin", connection), (int)3);
    }
}

