/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class BlobClob4BlobTest
extends BaseJDBCTestCase {
    private static final String BLOB_BAD_POSITION = "XJ070";
    private static final String BLOB_NONPOSITIVE_LENGTH = "XJ071";
    private static final String BLOB_POSITION_TOO_LARGE = "XJ076";
    private static final String LANG_DATA_TYPE_GET_MISMATCH = "22005";
    private static final String BLOB_NULL_PATTERN_OR_SEARCH_STR = "XJ072";
    private static final String LOCK_TIMEOUT = "40XL1";
    private static final String NO_CURRENT_CONNECTION = "08003";
    private static final String INVALID_LOB = "XJ215";

    public BlobClob4BlobTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE testClob (b INT, c INT)");
        statement.executeUpdate("ALTER TABLE testClob ADD COLUMN a CLOB(300K)");
        this.checkSmallPageSize(statement, "TESTCLOB");
        statement.executeUpdate("CREATE TABLE testBlob (b INT)");
        statement.executeUpdate("ALTER TABLE testBlob ADD COLUMN a blob(300k)");
        statement.executeUpdate("ALTER TABLE testBlob ADD COLUMN crc32 BIGINT");
        this.checkSmallPageSize(statement, "TESTBLOB");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        Statement statement = this.createStatement();
        statement.executeUpdate("DROP TABLE testClob");
        statement.executeUpdate("DROP TABLE testBlob");
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testUnconsumedParameter() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table testing(num int, addr varchar(40), contents blob(16M))");
        byte[] byArray = new byte[38000];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 97;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = "UPDATE testing SET Contents=? WHERE num=1";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
        this.commit();
        preparedStatement.executeUpdate();
        statement.executeUpdate("insert into testing values (1,null,null)");
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
        preparedStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("select length(contents) from testing where num = 1");
        JDBC.assertSingleValueResultSet(resultSet, "38000");
        preparedStatement.close();
        connection.commit();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        string = "UPDATE testing SET Contents=? WHERE num=2";
        preparedStatement = this.prepareStatement(string);
        preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("drop table testing");
        connection.commit();
        statement.executeUpdate("create table testing(num int, addr varchar(40), contents blob(16M),contents2 blob(16M))");
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        string = "UPDATE testing SET Contents=?, contents2=?  WHERE num=1";
        preparedStatement = this.prepareStatement(string);
        preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream2, byArray.length);
        preparedStatement.executeUpdate();
        statement.executeUpdate("insert into testing values (1,'addr',NULL,NULL)");
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream2, byArray.length);
        preparedStatement.executeUpdate();
        resultSet = statement.executeQuery("select length(contents), length(contents2) from testing where num = 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"38000", "38000"}});
        resultSet.close();
        statement.executeUpdate("drop table testing");
        statement.executeUpdate("create table testing(num int, addr varchar(40), contents Clob(16M))");
        char[] cArray = new char[38000];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 97;
        }
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        string = "UPDATE testing SET Contents=? WHERE num=1";
        preparedStatement = this.prepareStatement(string);
        preparedStatement.setCharacterStream(1, (Reader)charArrayReader, cArray.length);
        preparedStatement.executeUpdate();
        statement.executeUpdate("insert into testing values (1,null,null)");
        charArrayReader = new CharArrayReader(cArray);
        preparedStatement.setCharacterStream(1, (Reader)charArrayReader, byArray.length);
        preparedStatement.executeUpdate();
        resultSet = statement.executeQuery("select length(contents) from testing where num = 1");
        JDBC.assertSingleValueResultSet(resultSet, "38000");
        statement.executeUpdate("drop table testing");
        preparedStatement.close();
        connection.commit();
    }

    public void testIsolationLevelChangeAfterRead() throws SQLException {
        ResultSet resultSet = this.createStatement().executeQuery("VALUES CAST(X'FFFF' AS BLOB)");
        JDBC.assertDrainResults(resultSet);
        this.getConnection().setTransactionIsolation(8);
    }

    public void testSetCharacterStream() throws Exception {
        int n = 5009;
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob (a) values(?)");
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader((long)n, CharAlphabet.tamil());
        preparedStatement.setCharacterStream(1, (Reader)loopingAlphabetReader, n);
        this.commit();
        preparedStatement.executeUpdate();
        ((Reader)loopingAlphabetReader).close();
        preparedStatement.close();
        this.commit();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT a FROM testClob");
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (long)n, (long)clob.length());
            Reader reader = clob.getCharacterStream();
            LoopingAlphabetReader loopingAlphabetReader2 = new LoopingAlphabetReader((long)n, CharAlphabet.tamil());
            BlobClob4BlobTest.assertTrue((String)"New clob value did not match", (boolean)this.compareReaders(loopingAlphabetReader2, reader));
            ((Reader)loopingAlphabetReader2).close();
            reader.close();
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testGetAsciiStream() throws Exception {
        byte[] byArray = new byte[1024];
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT a, b FROM testClob");
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            if (clob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob.length()", (long)n, (long)clob.length());
                InputStream inputStream = clob.getAsciiStream();
                int n2 = 0;
                int n3 = -1;
                do {
                    n2 += (n3 = inputStream.read(byArray)) > 0 ? n3 : 0;
                } while (n3 >= 0);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)n, (int)n2);
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"Clob was null but length was not 0", (n == 0 ? 1 : 0) != 0);
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testGetCharacterStream() throws Exception {
        char[] cArray = new char[128];
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a , b from testClob");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 0;
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            n = resultSet.getInt(2);
            if (clob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob.length()", (long)n, (long)clob.length());
                Reader reader = clob.getCharacterStream();
                int n2 = 0;
                int n3 = -1;
                do {
                    n2 += (n3 = reader.read(cArray)) >= 0 ? n3 : 0;
                } while (n3 >= 0);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)n, (int)n2);
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"Clob was null but length was not 0", (n == 0 ? 1 : 0) != 0);
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testGetCharacterStreamWithUnicode() throws Exception {
        String[] stringArray = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(stringArray);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT a, b, c FROM testClob");
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            n = resultSet.getInt(2);
            n2 = resultSet.getInt(3);
            Clob clob = resultSet.getClob(1);
            if (clob != null) {
                Object object;
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob.length()", (long)n, (long)clob.length());
                Reader reader = clob.getCharacterStream();
                if (n2 > 0) {
                    object = new char[3];
                    reader.read((char[])object);
                    BlobClob4BlobTest.assertEquals((String)"Clob value does not match unicodeString", (String)stringArray[n2], (String)new String((char[])object));
                    BlobClob4BlobTest.assertEquals((String)"Expected end of stream", (int)-1, (int)reader.read());
                    continue;
                }
                object = new LoopingAlphabetReader((long)n, CharAlphabet.tamil());
                this.compareReaders((Reader)object, reader);
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"Clob was null but length was not 0", (n == 0 ? 1 : 0) != 0);
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void baseTestTriggersWithClobColumn(boolean bl) throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE testClobTriggerA (a CLOB(400k), b int)");
        statement.executeUpdate("CREATE TABLE testClobTriggerB (a CLOB(400k), b int)");
        statement.executeUpdate("create trigger T13A after update on testClob referencing new as n old as o for each row insert into testClobTriggerA(a, b) values (n.a, n.b)");
        statement.executeUpdate("create trigger T13B after INSERT on testClobTriggerA referencing new table as n for each statement insert into testClobTriggerB(a, b) select n.a, n.b from n");
        this.commit();
        statement.executeUpdate("UPDATE testClob SET b = b + 0");
        this.commit();
        Statement statement2 = this.createStatement();
        Statement statement3 = this.createStatement();
        Statement statement4 = this.createStatement();
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        ResultSet resultSet3 = null;
        if (bl) {
            resultSet = statement2.executeQuery("select a, length(a), b  from testClob order by b");
            resultSet2 = statement3.executeQuery("select a, length(a), b from testClobTriggerA order by b");
            resultSet3 = statement4.executeQuery("select a, length(a), b from testClobTriggerB order by b");
        } else {
            resultSet = statement2.executeQuery("select a, length(a), b  from testClob");
            resultSet2 = statement3.executeQuery("select a, length(a), b from testClobTriggerA");
            resultSet3 = statement4.executeQuery("select a, length(a), b from testClobTriggerB");
        }
        int n = 0;
        while (resultSet.next()) {
            BlobClob4BlobTest.assertTrue((String)("row trigger produced less rows " + ++n), (boolean)resultSet2.next());
            BlobClob4BlobTest.assertTrue((String)("statement trigger produced less rows " + n), (boolean)resultSet3.next());
            Clob clob = resultSet.getClob(1);
            if (clob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid checksum for row trigger", (long)this.getStreamCheckSum(clob.getAsciiStream()), (long)this.getStreamCheckSum(resultSet2.getClob(1).getAsciiStream()));
                BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid checksum for statement trigger", (long)this.getStreamCheckSum(clob.getAsciiStream()), (long)this.getStreamCheckSum(resultSet3.getClob(1).getAsciiStream()));
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid length in row trigger", (int)resultSet.getInt(2), (int)resultSet2.getInt(2));
            BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid length in statement trigger", (int)resultSet.getInt(2), (int)resultSet3.getInt(2));
            BlobClob4BlobTest.assertEquals((String)"FAIL - Length not updated on row trigger", (int)resultSet.getInt(3), (int)resultSet2.getInt(3));
            BlobClob4BlobTest.assertEquals((String)"FAIL - Length not updated on statement trigger", (int)resultSet.getInt(3), (int)resultSet3.getInt(3));
        }
        resultSet.close();
        resultSet2.close();
        resultSet3.close();
        statement2.close();
        statement3.close();
        statement4.close();
        statement.executeUpdate("DROP TRIGGER T13A");
        statement.executeUpdate("DROP TRIGGER T13B");
        statement.executeUpdate("DROP TABLE testClobTriggerB");
        statement.executeUpdate("DROP TABLE testClobTriggerA");
        statement.close();
        this.commit();
    }

    public void testTriggersWithClobColumnOrderBy() throws Exception {
        this.baseTestTriggersWithClobColumn(true);
    }

    public void testTriggersWithClobColumn() throws Exception {
        this.baseTestTriggersWithClobColumn(false);
    }

    public void testGetSubString() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        int n = 0;
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            if (clob == null) continue;
            n = resultSet.getInt(2);
            this.verifyInterval(clob, 9905L, 50, 0, n);
            this.verifyInterval(clob, 5910L, 150, 1, n);
            this.verifyInterval(clob, 5910L, 50, 2, n);
            this.verifyInterval(clob, 204L, 50, 3, n);
            this.verifyInterval(clob, 68L, 50, 4, n);
            this.verifyInterval(clob, 1L, 50, 5, n);
            this.verifyInterval(clob, 1L, 1, 6, n);
            this.verifyInterval(clob, 1L, 0, 7, n);
            this.verifyInterval(clob, (long)(n + 1), 0, 8, n);
            if (n <= 100) continue;
            String string = clob.getSubString(n - 99, 200);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong length of substring", (int)100, (int)string.length());
        }
        resultSet.close();
        statement.close();
    }

    public void testGetSubStringWithUnicode() throws Exception {
        String[] stringArray = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(stringArray);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b, c from testClob");
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            n = resultSet.getInt(2);
            n2 = resultSet.getInt(3);
            if (clob == null) continue;
            if (n2 >= 0) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring returned", (String)stringArray[n2], (String)clob.getSubString(1L, 3));
                continue;
            }
            if (clob.length() <= 0L) continue;
            long l = Math.min(clob.length() / 3L, 2048L);
            char[] cArray = new char[(int)l];
            Reader reader = clob.getCharacterStream();
            reader.read(cArray);
            reader.read(cArray);
            String string = clob.getSubString(l + 1L, (int)l);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring length", (int)cArray.length, (int)string.length());
            for (int i = 0; i < cArray.length; ++i) {
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong substring returned at " + i), (char)cArray[i], (char)string.charAt(i));
            }
        }
        resultSet.close();
        statement.close();
    }

    public void testPositionString() throws Exception {
        this.insertDefaultData();
        this.runPositionStringTest();
    }

    public void testPositionStringWithUnicode() throws Exception {
        String[] stringArray = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(stringArray);
        this.runPositionStringTest();
    }

    private void runPositionStringTest() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        int n = 0;
        Random random = new Random();
        int n2 = CharAlphabet.MODERNLATINLOWER.length;
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            n = resultSet.getInt(2);
            if (clob == null || n <= 0) continue;
            BlobClob4BlobTest.println("\n\nclobLength: " + n);
            for (int i = 0; i < 10; ++i) {
                int n3 = Math.max(random.nextInt(n - 1), 1);
                int n4 = random.nextInt(n - n3) + 1;
                BlobClob4BlobTest.println("start:" + n3 + " length:" + n4);
                String string = clob.getSubString(n3, n4);
                int n5 = random.nextInt(n2);
                int n6 = Math.max(n3 - n5, 1);
                String string2 = clob.getSubString(n6, n3);
                if (string2.indexOf(string) != -1) {
                    n6 = n3;
                }
                BlobClob4BlobTest.println("startSearchPos: " + n6 + "searchString: " + string);
                long l = clob.position(string, (long)n6);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + string + " start at " + n6 + " with length " + string.length()), (long)n3, (long)l);
            }
        }
        resultSet.close();
        statement.close();
    }

    public void testPositionClob() throws Exception {
        this.insertDefaultData();
        this.runPositionClobTest();
    }

    public void testPositionClobWithUnicode() throws Exception {
        String[] stringArray = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(stringArray);
        this.runPositionClobTest();
    }

    private void runPositionClobTest() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        int n = 0;
        Statement statement2 = this.createStatement();
        Random random = new Random();
        int n2 = CharAlphabet.MODERNLATINLOWER.length;
        while (resultSet.next()) {
            Object object;
            int n3;
            String string;
            int n4;
            Clob clob = resultSet.getClob(1);
            n = resultSet.getInt(2);
            if (clob == null || n <= 0) continue;
            BlobClob4BlobTest.println("\n\nclobLength: " + n);
            statement2.executeUpdate("CREATE TABLE searchClob (a clob(300K), start int, position int)");
            PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO searchClob values (?, ?, ?) ");
            for (int i = 0; i < 10; ++i) {
                n4 = Math.max(random.nextInt(n - 1), 1);
                int n5 = random.nextInt(n - n4) + 1;
                BlobClob4BlobTest.println("start:" + n4 + " length:" + n5);
                string = clob.getSubString(n4, n5);
                int n6 = random.nextInt(n2);
                n3 = Math.max(n4 - n6, 1);
                object = clob.getSubString(n3, n4);
                if (((String)object).indexOf(string) != -1) {
                    n3 = n4;
                }
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n3);
                preparedStatement.setInt(3, n4);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            ResultSet resultSet2 = statement2.executeQuery("SELECT a, start, position FROM searchClob");
            while (resultSet2.next()) {
                object = resultSet2.getClob(1);
                n3 = resultSet2.getInt(2);
                n4 = resultSet2.getInt(3);
                string = object.getSubString(1L, (int)object.length());
                BlobClob4BlobTest.println("startSearchPos: " + n3 + "searchString: " + string);
                long l = clob.position((Clob)object, (long)n3);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + string + " starting at " + n3 + " with length " + string.length()), (long)n4, (long)l);
            }
            resultSet2.close();
            statement2.executeUpdate("DROP TABLE searchClob");
        }
        resultSet.close();
        statement.close();
        statement2.close();
    }

    public void testSmallClobFields() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("ALTER TABLE testClob ADD COLUMN smallClob CLOB(10)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob (smallClob) values(?)");
        Object object = "";
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setString(1, (String)object);
            preparedStatement.executeUpdate();
            object = (String)object + "x";
        }
        ResultSet resultSet = statement.executeQuery("select a from testClob");
        byte[] byArray = new byte[128];
        int n = 0;
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            if (clob == null) continue;
            InputStream inputStream = clob.getAsciiStream();
            int n2 = 0;
            int n3 = 0;
            do {
                n2 += (n3 = inputStream.read(byArray)) > 0 ? n3 : 0;
            } while (n3 != -1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob size", (int)n, (int)n2);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (long)n, (long)clob.length());
            ++n;
        }
        resultSet.close();
        statement.close();
    }

    public void testGetClobFromIntColumn() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select b from testClob");
        while (resultSet.next()) {
            try {
                Clob clob = resultSet.getClob(1);
                resultSet.close();
                statement.close();
                BlobClob4BlobTest.fail((String)"FAIL - getClob on column type int should throw an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, sQLException);
            }
        }
        resultSet.close();
        statement.close();
    }

    public void testSetClobToIntColumn() throws Exception {
        this.insertDefaultData();
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob (b, c) values (?, ?)");
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            if (clob == null) continue;
            try {
                preparedStatement.setClob(1, clob);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                resultSet.close();
                statement.close();
                BlobClob4BlobTest.fail((String)"FAIL - can not use setClob on int column");
            }
            catch (SQLException sQLException) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, sQLException);
            }
        }
        resultSet.close();
        statement.close();
    }

    public void testRaisingOfExceptionsClob() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob WHERE a is not NULL");
        boolean bl = false;
        int n = 0;
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        n = resultSet.getInt(2);
        resultSet.close();
        BlobClob4BlobTest.assertFalse((String)"FAIL - clob can not be null", (clob == null ? 1 : 0) != 0);
        try {
            clob.getSubString(0L, 5);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with 0 as position should have caused an exception");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_BAD_POSITION, sQLException);
        }
        try {
            clob.getSubString(1L, -76);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with negative length should have caused an exception");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_NONPOSITIVE_LENGTH, sQLException);
        }
        try {
            clob.getSubString(1L, -1);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with negative length should have caused an exception");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_NONPOSITIVE_LENGTH, sQLException);
        }
        try {
            clob.getSubString(0L, 0);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with 0 as position should have caused an exception");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_BAD_POSITION, sQLException);
        }
        try {
            clob.getSubString(n + 2, 0);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with position bigger than clob should have caused an exception");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_POSITION_TOO_LARGE, sQLException);
        }
        try {
            clob.position("xx", -4000L);
            BlobClob4BlobTest.fail((String)"FAIL - position with negative as position should have caused an exception");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_BAD_POSITION, sQLException);
        }
        try {
            clob.position((String)null, 5L);
            BlobClob4BlobTest.fail((String)"FAIL = position((String) null,5)");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, sQLException);
        }
        try {
            clob.position(clob, -42L);
            BlobClob4BlobTest.fail((String)"FAIL = position(clob,-42)");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_BAD_POSITION, sQLException);
        }
        try {
            clob.position((Clob)null, 5L);
            BlobClob4BlobTest.fail((String)"FAIL = pposition((Clob) null,5)");
        }
        catch (SQLException sQLException) {
            this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, sQLException);
        }
    }

    public void testSetClob() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        statement.execute("create table testSetClob (a CLOB(300k), b integer)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testSetClob values(?,?)");
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            if (clob == null || n == 0) continue;
            preparedStatement.setClob(1, clob);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
        }
        resultSet.close();
        resultSet = statement.executeQuery("select a, b from testSetClob");
        boolean bl = false;
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            BlobClob4BlobTest.assertFalse((String)"FAIL - Clob is NULL", (clob == null ? 1 : 0) != 0);
            BlobClob4BlobTest.assertEquals((String)"FAIL - clob.length() != clobLength", (long)n, (long)clob.length());
        }
        resultSet.close();
        statement.executeUpdate("DROP TABLE testSetClob");
        statement.close();
    }

    public void testPositionAgressiveUseOrderBy() throws Exception {
        this.baseTestPositionAgressive(true);
    }

    public void testPositionAgressiveDoNotUseOrderBy() throws Exception {
        this.baseTestPositionAgressive(false);
    }

    public void baseTestPositionAgressive(boolean bl) throws Exception {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE C8.T8POS(id INT NOT NULL PRIMARY KEY, DD CLOB(1m), pos INT, L INT)");
        statement.execute("CREATE TABLE C8.T8PATT(PATT CLOB(300k))");
        char[] cArray = new char[]{'d', '\u03a9', '\u0e14', 'j'};
        char[] cArray2 = new char[262144];
        for (int i = 0; i < cArray2.length; i += 4) {
            cArray2[i] = cArray[0];
            cArray2[i + 1] = cArray[1];
            cArray2[i + 2] = cArray[2];
            cArray2[i + 3] = cArray[3];
        }
        char[] cArray3 = new char[2048];
        for (int i = 0; i < cArray3.length; i += 8) {
            cArray3[i] = 112;
            cArray3[i + 1] = 97;
            cArray3[i + 2] = 116;
            cArray3[i + 3] = 938;
            cArray3[i + 4] = (char)i;
            cArray3[i + 5] = 98;
            cArray3[i + 6] = 109;
            cArray3[i + 7] = 3605;
        }
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO C8.T8POS VALUES (?, ?, ?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("INSERT INTO C8.T8PATT VALUES (?)");
        BlobClob4BlobTest.T8insert(preparedStatement, 1, cArray2, 256, cArray3, 8, 100, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 2, cArray2, 3988, cArray3, 8, 2045, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 3, cArray2, 16321, cArray3, 8, 4566, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 4, cArray2, 45662, cArray3, 8, 34555, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 5, cArray2, 134752, cArray3, 8, 67889, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 6, cArray2, 303, cArray3, 8, 80, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 7, cArray2, 4566, cArray3, 8, 2086, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 8, cArray2, 17882, cArray3, 8, 4426, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 9, cArray2, 41567, cArray3, 8, 31455, false);
        String string = BlobClob4BlobTest.T8insert(preparedStatement, 10, cArray2, 114732, cArray3, 8, 87809, false);
        this.commit();
        preparedStatement2.setString(1, string);
        preparedStatement2.executeUpdate();
        BlobClob4BlobTest.checkClob8(statement, string, bl);
        this.commit();
        ResultSet resultSet = statement.executeQuery("SELECT PATT FROM C8.T8PATT");
        resultSet.next();
        BlobClob4BlobTest.checkClob8(statement, resultSet.getClob(1), bl);
        resultSet.close();
        this.commit();
        statement.execute("DELETE FROM C8.T8POS");
        statement.execute("DELETE FROM C8.T8PATT");
        BlobClob4BlobTest.T8insert(preparedStatement, 1, cArray2, 256, cArray3, 134, 100, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 2, cArray2, 3988, cArray3, 134, 2045, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 3, cArray2, 16321, cArray3, 134, 4566, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 4, cArray2, 45662, cArray3, 134, 34555, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 5, cArray2, 134752, cArray3, 134, 67889, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 6, cArray2, 303, cArray3, 134, 80, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 7, cArray2, 4566, cArray3, 134, 2086, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 8, cArray2, 17882, cArray3, 134, 4426, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 9, cArray2, 41567, cArray3, 134, 31455, false);
        string = BlobClob4BlobTest.T8insert(preparedStatement, 10, cArray2, 114732, cArray3, 134, 87809, false);
        this.commit();
        preparedStatement2.setString(1, string);
        preparedStatement2.executeUpdate();
        this.commit();
        BlobClob4BlobTest.checkClob8(statement, string, bl);
        this.commit();
        resultSet = statement.executeQuery("SELECT PATT FROM C8.T8PATT");
        resultSet.next();
        BlobClob4BlobTest.checkClob8(statement, resultSet.getClob(1), bl);
        statement.execute("DELETE FROM C8.T8POS");
        statement.execute("DELETE FROM C8.T8PATT");
        BlobClob4BlobTest.T8insert(preparedStatement, 1, cArray2, 256, cArray3, 679, 100, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 2, cArray2, 3988, cArray3, 679, 2045, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 3, cArray2, 16321, cArray3, 679, 4566, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 4, cArray2, 45662, cArray3, 679, 34555, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 5, cArray2, 134752, cArray3, 679, 67889, true);
        BlobClob4BlobTest.T8insert(preparedStatement, 6, cArray2, 303, cArray3, 679, 80, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 7, cArray2, 4566, cArray3, 679, 2086, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 8, cArray2, 17882, cArray3, 679, 4426, false);
        BlobClob4BlobTest.T8insert(preparedStatement, 9, cArray2, 41567, cArray3, 679, 31455, false);
        string = BlobClob4BlobTest.T8insert(preparedStatement, 10, cArray2, 114732, cArray3, 679, 87809, false);
        this.commit();
        preparedStatement2.setString(1, string);
        preparedStatement2.executeUpdate();
        this.commit();
        BlobClob4BlobTest.checkClob8(statement, string, bl);
        this.commit();
        resultSet = statement.executeQuery("SELECT PATT FROM C8.T8PATT");
        resultSet.next();
        BlobClob4BlobTest.checkClob8(statement, resultSet.getClob(1), bl);
        statement.execute("DELETE FROM C8.T8POS");
        statement.execute("DELETE FROM C8.T8PATT");
        preparedStatement.close();
        preparedStatement2.close();
        statement.execute("DROP TABLE C8.T8POS");
        statement.execute("DROP TABLE C8.T8PATT");
        statement.close();
        this.commit();
    }

    private static String T8insert(PreparedStatement preparedStatement, int n, char[] cArray, int n2, char[] cArray2, int n3, int n4, boolean bl) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, 0, n2);
        int n5 = BlobClob4BlobTest.addPatternPrefix(stringBuffer, cArray2, n3, 5, 10);
        if (n5 >= n4 / 2) {
            n4 = (n5 + 10) * 2;
        }
        if ((n5 = BlobClob4BlobTest.addPatternPrefix(stringBuffer, cArray2, n3, n3 / 2, n4 / 2)) >= n4) {
            n4 = n5 + 13;
        }
        n4 = BlobClob4BlobTest.addPatternPrefix(stringBuffer, cArray2, n3, n3 - 1, n4);
        if (bl) {
            stringBuffer.insert(n4, cArray2, 0, n3);
        } else {
            n4 = -1;
        }
        String string = stringBuffer.toString();
        String string2 = new String(cArray2, 0, n3);
        BlobClob4BlobTest.assertEquals((String)"FAIL - test confused pattern not at expected location", (int)n4, (int)string.indexOf(string2));
        if (n4 != -1) {
            ++n4;
        }
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setInt(3, n4);
        preparedStatement.setInt(4, string.length());
        preparedStatement.executeUpdate();
        return string2;
    }

    private static int addPatternPrefix(StringBuffer stringBuffer, char[] cArray, int n, int n2, int n3) {
        for (int i = 0; i < n2 && i < n - 1; ++i) {
            stringBuffer.insert(n3, cArray, 0, i + 1);
            n3 += i + 1;
        }
        return n3;
    }

    private static void checkClob8(Statement statement, String string, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        resultSet = bl ? statement.executeQuery("SELECT ID, DD, POS, L FROM C8.T8POS ORDER BY 1") : statement.executeQuery("SELECT ID, DD, POS, L FROM C8.T8POS");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            Clob clob = resultSet.getClob(2);
            int n2 = resultSet.getInt(3);
            int n3 = resultSet.getInt(4);
            long l = clob.position(string, 1L);
            BlobClob4BlobTest.assertEquals((String)"FAIL - position did not match", (long)n2, (long)l);
        }
        resultSet.close();
    }

    private static void checkClob8(Statement statement, Clob clob, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        resultSet = bl ? statement.executeQuery("SELECT ID, DD, POS, L FROM C8.T8POS ORDER BY 1") : statement.executeQuery("SELECT ID, DD, POS, L FROM C8.T8POS");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            Clob clob2 = resultSet.getClob(2);
            int n2 = resultSet.getInt(3);
            int n3 = resultSet.getInt(4);
            long l = clob2.position(clob, 1L);
            BlobClob4BlobTest.assertEquals((String)"FAIL - position did not match", (long)n2, (long)l);
        }
        resultSet.close();
    }

    public void testClobAfterClose() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        byte[] byArray = new byte[128];
        Clob[] clobArray = new Clob[10];
        int[] nArray = new int[10];
        int n = 0;
        while (resultSet.next()) {
            clobArray[n] = resultSet.getClob(1);
            nArray[n++] = resultSet.getInt(2);
        }
        resultSet.close();
        statement.close();
        for (int i = 0; i < 10; ++i) {
            int n2;
            if (clobArray[i] == null) continue;
            InputStream inputStream = clobArray[i].getAsciiStream();
            int n3 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                n3 += n2;
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)n3, (int)nArray[i]);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (long)n3, (long)clobArray[i].length());
        }
    }

    public void testLockingClob() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        Clob clob = null;
        Clob clob2 = null;
        while (resultSet.next()) {
            int n = resultSet.getInt(2);
            if (n == 10000) {
                clob = resultSet.getClob(1);
            }
            if (n != 26) continue;
            clob2 = resultSet.getClob(1);
        }
        resultSet.close();
        statement.close();
        BlobClob4BlobTest.assertTrue((String)"shortClob is null", (clob2 != null ? 1 : 0) != 0);
        BlobClob4BlobTest.assertTrue((String)"clob is null", (clob != null ? 1 : 0) != 0);
        Connection connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("update testClob set a = 'foo' where b = 26");
        BlobClob4BlobTest.assertEquals((String)"FAIL: clob length changed", (long)26L, (long)clob2.length());
        try {
            statement2.executeUpdate("update testClob set b = b + 1 where b = 10000");
            statement2.close();
            connection.rollback();
            connection.close();
            BlobClob4BlobTest.fail((String)"FAIL: row should be locked");
        }
        catch (SQLException sQLException) {
            this.checkException(LOCK_TIMEOUT, sQLException);
        }
        BlobClob4BlobTest.assertEquals((String)"FAIL: clob length changed", (long)10000L, (long)clob.length());
        this.commit();
        statement2.executeUpdate("update testClob set b = b + 1 where b = 10000");
        statement2.close();
        connection.rollback();
        connection.close();
    }

    public void testLockingWithLongRowClob() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("alter table testClob add column al varchar(2000)");
        statement.execute("alter table testClob add column bl varchar(3000)");
        statement.execute("alter table testClob add column cl varchar(2000)");
        statement.execute("alter table testClob add column dl varchar(3000)");
        statement.execute("alter table testClob add column el CLOB(400k)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob (al, bl, cl, dl, el, b) values(?,?,?,?,?,?)");
        preparedStatement.setString(1, Formatters.padString("blaaa", 2000));
        preparedStatement.setString(2, Formatters.padString("tralaaaa", 3000));
        preparedStatement.setString(3, Formatters.padString("foodar", 2000));
        preparedStatement.setString(4, Formatters.padString("moped", 3000));
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(10000L);
        preparedStatement.setAsciiStream(5, (InputStream)loopingAlphabetStream, 10000);
        preparedStatement.setInt(6, 1);
        this.commit();
        preparedStatement.executeUpdate();
        loopingAlphabetStream.close();
        preparedStatement.close();
        this.commit();
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select el from testClob");
        Clob clob = null;
        BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        BlobClob4BlobTest.assertTrue((String)"FAIL - clob is null", (clob != null ? 1 : 0) != 0);
        resultSet.close();
        statement.close();
        Connection connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        Statement statement2 = connection.createStatement();
        try {
            statement2.executeUpdate("update testClob set el = 'smurfball' where b = 1");
            statement2.close();
            connection.rollback();
            connection.close();
            BlobClob4BlobTest.fail((String)"FAIL - statement should timeout");
        }
        catch (SQLException sQLException) {
            this.checkException(LOCK_TIMEOUT, sQLException);
        }
        this.commit();
        statement2.executeUpdate("update testClob set el = 'smurfball' where b = 1");
        statement2.close();
        connection.commit();
        connection.close();
    }

    public void testClobAfterCommit() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a,b from testClob");
        Clob clob = null;
        Clob clob2 = null;
        boolean bl = false;
        while (resultSet.next()) {
            int n = resultSet.getInt(2);
            if (n == 10000) {
                clob = resultSet.getClob(1);
            }
            if (n != 26) continue;
            clob2 = resultSet.getClob(1);
        }
        clob.length();
        clob2.length();
        resultSet.close();
        statement.close();
        this.commit();
        BlobClob4BlobTest.assertTrue((String)"FAIL - shortClob is NULL", (clob2 != null ? 1 : 0) != 0);
        try {
            clob2.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access Clob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            clob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            clob.getSubString(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            clob.getAsciiStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            clob.position("foo", 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            clob.position(clob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
    }

    public void testClobAfterClosingConnection() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a,b from testClob");
        Clob clob = null;
        Clob clob2 = null;
        while (resultSet.next()) {
            int n = resultSet.getInt(2);
            if (n == 10000) {
                clob = resultSet.getClob(1);
            }
            if (n != 26) continue;
            clob2 = resultSet.getClob(1);
        }
        clob.length();
        clob2.length();
        resultSet.close();
        statement.close();
        this.commit();
        this.getConnection().close();
        try {
            long l = clob2.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access Clob after Connection Close");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            clob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            clob.getSubString(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            clob.getAsciiStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            clob.position("foo", 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            clob.position(clob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
    }

    public void testClobAfterCommitWithSecondClob() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values cast('first' as clob)");
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        this.commit();
        Statement statement2 = this.createStatement();
        ResultSet resultSet2 = statement2.executeQuery("values cast('second' as clob)");
        resultSet2.next();
        Clob clob2 = resultSet2.getClob(1);
        try {
            clob.getSubString(1L, 100);
            BlobClob4BlobTest.fail((String)"first.getSubString should have failed because after the commit");
        }
        catch (SQLException sQLException) {
            BlobClob4BlobTest.assertSQLState(INVALID_LOB, sQLException);
        }
        BlobClob4BlobTest.assertEquals((String)"second", (String)clob2.getSubString(1L, 100));
        resultSet2.close();
    }

    public void testGetClobBeforeAndAfterUpdate() throws SQLException {
        String string = "initial clob ";
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, string + i);
            preparedStatement.execute();
        }
        preparedStatement.close();
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT b, a FROM testClob");
        resultSet.first();
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.next();
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.relative(3);
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.absolute(7);
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.previous();
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.last();
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.previous();
        this.checkContentsBeforeAndAfterUpdatingClob(resultSet);
        resultSet.close();
        statement.close();
    }

    private void checkContentsBeforeAndAfterUpdatingClob(ResultSet resultSet) throws SQLException {
        String string = "initial clob ";
        String string2 = "updated clob ";
        Clob clob = resultSet.getClob(2);
        Object object = clob.getSubString(1L, (int)clob.length());
        String string3 = string + resultSet.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)string3, (String)object);
        object = string2 + resultSet.getInt(1);
        clob.setString(1L, (String)object);
        resultSet.updateClob(2, clob);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        clob = resultSet.getClob(2);
        object = clob.getSubString(1L, (int)clob.length());
        string3 = string2 + resultSet.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)string3, (String)object);
    }

    public void testGetClobBeforeAndAfterUpdateStream() throws SQLException {
        String string = "initial clob ";
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, string + i);
            preparedStatement.execute();
        }
        preparedStatement.close();
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT b, a FROM testClob");
        resultSet.first();
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.next();
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.relative(3);
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.absolute(7);
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.previous();
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.last();
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.previous();
        this.updateClobWithUpdateCharacterStream(resultSet);
        resultSet.close();
        statement.close();
    }

    private void updateClobWithUpdateCharacterStream(ResultSet resultSet) throws SQLException {
        String string = "initial clob ";
        String string2 = "updated clob ";
        Clob clob = resultSet.getClob(2);
        Object object = clob.getSubString(1L, (int)clob.length());
        String string3 = string + resultSet.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)string3, (String)object);
        object = string2 + resultSet.getInt(1);
        StringReader stringReader = new StringReader((String)object);
        resultSet.updateCharacterStream(2, (Reader)stringReader, ((String)object).length());
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        clob = resultSet.getClob(2);
        object = clob.getSubString(1L, (int)clob.length());
        string3 = string2 + resultSet.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)string3, (String)object);
    }

    public void testClobFinalizer() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob");
        Clob[] clobArray = new Clob[10];
        int[] nArray = new int[10];
        int n = 0;
        while (resultSet.next()) {
            clobArray[n] = resultSet.getClob(1);
            nArray[n++] = resultSet.getInt(2);
        }
        resultSet.close();
        statement.close();
        for (int i = 0; i < 10; ++i) {
            clobArray[i] = null;
        }
        System.gc();
        System.gc();
    }

    public void testGetBinaryStream() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b, crc32 from testBlob");
        this.testBlobContents(resultSet);
        statement.close();
        this.commit();
    }

    public void testGetBytes() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a,b from testBlob");
        int n = 0;
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            n = resultSet.getInt(2);
            if (blob != null) {
                this.verifyInterval(blob, 9905L, 50, 0, n);
                this.verifyInterval(blob, 5910L, 150, 1, n);
                this.verifyInterval(blob, 5910L, 50, 2, n);
                this.verifyInterval(blob, 204L, 50, 3, n);
                this.verifyInterval(blob, 68L, 50, 4, n);
                this.verifyInterval(blob, 1L, 50, 5, n);
                this.verifyInterval(blob, 1L, 1, 6, n);
                this.verifyInterval(blob, 1L, 0, 7, n);
                this.verifyInterval(blob, (long)(n + 1), 0, 8, n);
                if (n <= 100) continue;
                byte[] byArray = blob.getBytes(n - 99, 200);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong length in bytes", (int)100, (int)byArray.length);
                InputStream inputStream = blob.getBinaryStream();
                long l = 0L;
                for (long i = (long)(n - 100); i > 0L && l != -1L; i -= (l = inputStream.skip(Math.min(1024L, i))) > 0L ? l : 0L) {
                }
                byte[] byArray2 = new byte[100];
                l = inputStream.read(byArray2);
                inputStream.close();
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong value", (String)new String(byArray2), (String)new String(byArray));
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"FAIL - blob was NULL but length != 0", (n == 0 ? 1 : 0) != 0);
        }
        statement.close();
        this.commit();
    }

    public void testPositionBytes() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testBlob");
        int n = 0;
        Random random = new Random();
        int n2 = CharAlphabet.MODERNLATINLOWER.length;
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            n = resultSet.getInt(2);
            if (blob == null || n <= 0) continue;
            BlobClob4BlobTest.println("\n\nblobLength: " + n);
            for (int i = 0; i < 10; ++i) {
                int n3 = Math.max(random.nextInt(n - 1), 1);
                int n4 = random.nextInt(n - n3) + 1;
                BlobClob4BlobTest.println("start:" + n3 + " length:" + n4);
                byte[] byArray = blob.getBytes(n3, n4);
                String string = new String(byArray, "US-ASCII");
                int n5 = random.nextInt(n2);
                int n6 = Math.max(n3 - n5, 1);
                byte[] byArray2 = blob.getBytes(n6, n3);
                if (new String(byArray2, "US-ASCII").indexOf(string) != -1) {
                    n6 = n3;
                }
                BlobClob4BlobTest.println("startSearchPos: " + n6 + "searchString: " + new String(byArray));
                long l = blob.position(byArray, (long)n6);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + string + " starting at " + n6 + " and length of " + byArray.length), (long)n3, (long)l);
            }
        }
        resultSet.close();
        statement.close();
    }

    public void testPositionBlobDeterministic() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testBlob (a, b) VALUES (?, ?)");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(100000L), 100000);
        preparedStatement.setInt(2, 100000);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select a from testBlob where b = ?");
        preparedStatement.setInt(1, 100000);
        ResultSet resultSet = preparedStatement.executeQuery();
        BlobClob4BlobTest.assertTrue((String)"No data found", (boolean)resultSet.next());
        Blob blob = resultSet.getBlob(1);
        byte[] byArray = new byte[]{107};
        BlobClob4BlobTest.assertEquals((long)11L, (long)blob.position(byArray, 1L));
        byArray = new byte[]{112, 111};
        BlobClob4BlobTest.assertEquals((long)-1L, (long)blob.position(byArray, 33333L));
        byArray = new byte[]{100, 101};
        long l = 1L;
        int n = 0;
        int n2 = ByteAlphabet.modernLatinLowercase().byteCount();
        while ((l = blob.position(byArray, l + 1L)) != -1L) {
            BlobClob4BlobTest.assertEquals((long)(n2 * n++ + 4), (long)l);
            byte[] byArray2 = blob.getBytes(l, byArray.length);
            BlobClob4BlobTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
        }
        int n3 = 66560;
        byArray = new byte[n3];
        BlobClob4BlobTest.assertEquals((int)n3, (int)new LoopingAlphabetStream(n3).read(byArray));
        BlobClob4BlobTest.assertEquals((long)1L, (long)blob.position(byArray, 1L));
        BlobClob4BlobTest.assertEquals((long)(n2 * 100 + 1), (long)blob.position(byArray, (long)(n2 * 99 + 7)));
        BlobClob4BlobTest.assertEquals((long)100000L, (long)blob.length());
        BlobClob4BlobTest.assertEquals((long)(n2 * 100 + 1), (long)blob.position(byArray, (long)(n2 * 99 + 7)));
        try {
            blob.position(byArray, 200000L);
            BlobClob4BlobTest.fail((String)"Accepted position after end of Blob");
        }
        catch (SQLException sQLException) {
            BlobClob4BlobTest.assertSQLState(BLOB_POSITION_TOO_LARGE, sQLException);
        }
        byte[] byArray3 = blob.getBytes(99996L, 5);
        byArray = new byte[6];
        System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        byArray[5] = 88;
        BlobClob4BlobTest.assertEquals((long)-1L, (long)blob.position(byArray, 99990L));
        byArray3 = blob.getBytes(100000L, 1);
        byArray = new byte[]{byArray3[0], 88};
        BlobClob4BlobTest.assertEquals((long)-1L, (long)blob.position(byArray, 99995L));
    }

    public void testPositionBlob() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testBlob");
        int n = 0;
        Statement statement2 = this.createStatement();
        Random random = new Random();
        int n2 = CharAlphabet.MODERNLATINLOWER.length;
        while (resultSet.next()) {
            Object object;
            int n3;
            String string;
            int n4;
            Blob blob = resultSet.getBlob(1);
            n = resultSet.getInt(2);
            if (blob == null || n <= 0) continue;
            BlobClob4BlobTest.println("\n\nblobLength: " + n);
            statement2.executeUpdate("CREATE TABLE searchBlob (a Blob(300K), start int, position int)");
            PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO searchBlob values (?, ?, ?) ");
            for (int i = 0; i < 10; ++i) {
                n4 = Math.max(random.nextInt(n - 1), 1);
                int n5 = random.nextInt(n - n4) + 1;
                BlobClob4BlobTest.println("start:" + n4 + " length:" + n5);
                string = new String(blob.getBytes(n4, n5), "US-ASCII");
                int n6 = random.nextInt(n2);
                n3 = Math.max(n4 - n6, 1);
                object = new String(blob.getBytes(n3, n4), "US-ASCII");
                if (((String)object).indexOf(string) != -1) {
                    n3 = n4;
                }
                preparedStatement.setBytes(1, string.getBytes("US-ASCII"));
                preparedStatement.setInt(2, n3);
                preparedStatement.setInt(3, n4);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            ResultSet resultSet2 = statement2.executeQuery("SELECT a, start, position FROM searchBlob");
            while (resultSet2.next()) {
                object = resultSet2.getBlob(1);
                n3 = resultSet2.getInt(2);
                n4 = resultSet2.getInt(3);
                string = new String(object.getBytes(1L, (int)object.length()), "US-ASCII");
                BlobClob4BlobTest.println("startSearchPos: " + n3 + "searchString: " + string);
                long l = blob.position((Blob)object, (long)n3);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + string + " starting at " + n3 + " and length of " + string.length()), (long)n4, (long)l);
            }
            resultSet2.close();
            statement2.executeUpdate("DROP TABLE searchBlob");
        }
        resultSet.close();
        statement.close();
        statement2.close();
    }

    public void testTriggerWithBlobColumn() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE blobTest8TriggerA (a BLOB(400k), b int, crc32 BIGINT)");
        statement.executeUpdate("CREATE TABLE blobTest8TriggerB (a BLOB(400k), b int, crc32 BIGINT)");
        statement.executeUpdate("create trigger T8A after update on testBlob referencing new as n old as o for each row insert into blobTest8TriggerA(a, b, crc32) values (n.a, n.b, n.crc32)");
        statement.executeUpdate("create trigger T8B after INSERT on blobTest8TriggerA referencing new table as n for each statement insert into blobTest8TriggerB(a, b, crc32) select n.a, n.b, n.crc32 from n");
        this.commit();
        ResultSet resultSet = statement.executeQuery("select a,b,crc32 from blobTest8TriggerA");
        BlobClob4BlobTest.assertFalse((String)"FAIL - Table blobTest8TriggerA should contain no rows", (boolean)resultSet.next());
        resultSet.close();
        this.commit();
        statement.executeUpdate("UPDATE testBlob set b = b + 0");
        this.commit();
        resultSet = statement.executeQuery("select a,b,crc32 from blobTest8TriggerA");
        this.testBlobContents(resultSet);
        resultSet.close();
        this.commit();
        resultSet = statement.executeQuery("select a,b,crc32 from blobTest8TriggerB");
        this.testBlobContents(resultSet);
        resultSet.close();
        this.commit();
        statement.executeUpdate("DROP TRIGGER T8A");
        statement.executeUpdate("DROP TRIGGER T8B");
        statement.executeUpdate("DROP TABLE blobTest8TriggerB");
        statement.executeUpdate("DROP TABLE blobTest8TriggerA");
        statement.close();
        this.commit();
    }

    public void testVarbinary() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("ALTER TABLE testBlob ADD COLUMN smallBlob blob(13)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlob (smallBlob) values (?)");
        Object object = "";
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setBytes(1, ((String)object).getBytes("US-ASCII"));
            preparedStatement.executeUpdate();
            object = ((String)object).trim() + "x";
        }
        ResultSet resultSet = statement.executeQuery("select smallBlob from testBlob");
        byte[] byArray = new byte[128];
        int n = 0;
        while (resultSet.next()) {
            int n2;
            Blob blob = resultSet.getBlob(1);
            BlobClob4BlobTest.assertTrue((String)"FAIL - blob is null", (blob != null ? 1 : 0) != 0);
            InputStream inputStream = blob.getBinaryStream();
            int n3 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                n3 += n2;
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - unexpected blob size", (int)n, (int)n3);
            BlobClob4BlobTest.assertEquals((String)"FAIL - unexpected blob length", (long)n, (long)blob.length());
            ++n;
        }
        preparedStatement.close();
        statement.close();
        this.commit();
    }

    public void testGetBlobFromIntColumn() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select b from testClob");
        while (resultSet.next()) {
            try {
                Blob blob = resultSet.getBlob(1);
                resultSet.close();
                statement.close();
                BlobClob4BlobTest.fail((String)"FAIL - getBlob on int column should throw an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, sQLException);
            }
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testSetBlobOnIntColumn() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlob (b) values(?)");
        ResultSet resultSet = statement.executeQuery("select a,b from testBlob");
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            if (blob == null) continue;
            try {
                preparedStatement.setBlob(1, blob);
                preparedStatement.executeUpdate();
                resultSet.close();
                statement.close();
                preparedStatement.close();
                BlobClob4BlobTest.fail((String)"FAIL - setBlob worked on INT column");
            }
            catch (SQLException sQLException) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, sQLException);
            }
        }
        resultSet.close();
        statement.close();
        preparedStatement.close();
        this.commit();
    }

    public void testRaisingOfExceptionsBlob() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a,b from testBlob");
        int n = 0;
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            n = resultSet.getInt(2);
            if (blob == null) continue;
            try {
                blob.getBytes(0L, 5);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with 0 as position should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_BAD_POSITION, sQLException);
            }
            try {
                blob.getBytes(1L, -76);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with negative length should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_NONPOSITIVE_LENGTH, sQLException);
            }
            try {
                blob.getBytes(1L, -1);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with negative length should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_NONPOSITIVE_LENGTH, sQLException);
            }
            try {
                blob.getBytes(0L, 0);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with 0 position and length should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_BAD_POSITION, sQLException);
            }
            try {
                blob.getBytes(n + 2, 0);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with position larger than the length of the blob should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_POSITION_TOO_LARGE, sQLException);
            }
            try {
                blob.position(new byte[0], -4000L);
                BlobClob4BlobTest.fail((String)"FAIL - position with negative start position should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_BAD_POSITION, sQLException);
            }
            try {
                blob.position((byte[])null, 5L);
                BlobClob4BlobTest.fail((String)"FAIL - position with null pattern should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, sQLException);
            }
            try {
                blob.position(blob, -42L);
                BlobClob4BlobTest.fail((String)"FAIL - position with negative start position should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_BAD_POSITION, sQLException);
            }
            try {
                blob.position((Blob)null, 5L);
                BlobClob4BlobTest.fail((String)"FAIL - position with null pattern should have caused an exception");
            }
            catch (SQLException sQLException) {
                this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, sQLException);
            }
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testSetBlob() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        statement.execute("create table testBlobX (a blob(300K), b integer)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlobX values(?,?)");
        ResultSet resultSet = statement.executeQuery("select a, b from testBlob");
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            int n = resultSet.getInt(2);
            if (blob == null) continue;
            preparedStatement.setBlob(1, blob);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
        }
        resultSet.close();
        this.commit();
        resultSet = statement.executeQuery("select a,b from testBlobX");
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            int n = resultSet.getInt(2);
            BlobClob4BlobTest.assertTrue((String)"FAIL - blob is NULL", (blob != null ? 1 : 0) != 0);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong blob length", (long)blob.length(), (long)n);
        }
        resultSet.close();
        statement.executeUpdate("DROP TABLE testBlobX");
        statement.close();
        this.commit();
    }

    public void testBlobAfterClose() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a,b from testBlob");
        byte[] byArray = new byte[128];
        Blob[] blobArray = new Blob[10];
        int[] nArray = new int[10];
        int n = 0;
        while (resultSet.next()) {
            blobArray[n] = resultSet.getBlob(1);
            nArray[n++] = resultSet.getInt(2);
        }
        resultSet.close();
        statement.close();
        for (int i = 0; i < 10; ++i) {
            int n2;
            if (blobArray[i] == null) continue;
            InputStream inputStream = blobArray[i].getBinaryStream();
            int n3 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                n3 += n2;
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - invalid length", (int)nArray[i], (int)n3);
            BlobClob4BlobTest.assertEquals((String)"FAIL - invalid length", (long)n3, (long)blobArray[i].length());
        }
    }

    public void testLockingBlob() throws Exception {
        Statement statement = this.createStatement();
        this.insertDefaultData();
        BlobClob4BlobTest.assertFalse((boolean)this.getConnection().getAutoCommit());
        this.checkSmallPageSize(statement, "TESTBLOB");
        ResultSet resultSet = statement.executeQuery("select a,b from testBlob");
        Blob blob = null;
        Blob blob2 = null;
        while (resultSet.next()) {
            int n = resultSet.getInt(2);
            if (n == 10000) {
                blob = resultSet.getBlob(1);
            }
            if (n != 26) continue;
            blob2 = resultSet.getBlob(1);
        }
        resultSet.close();
        Connection connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("update testBlob set a = null where b = 26");
        BlobClob4BlobTest.assertEquals((String)"FAIL - blob was updated", (long)26L, (long)blob2.length());
        try {
            statement2.executeUpdate("update testBlob set b = b + 1 where b = 10000");
            statement.close();
            statement2.close();
            connection.rollback();
            connection.close();
            BlobClob4BlobTest.fail((String)"FAIL - should have gotten lock timeout");
        }
        catch (SQLException sQLException) {
            this.checkException(LOCK_TIMEOUT, sQLException);
        }
        BlobClob4BlobTest.assertTrue((blob != null ? 1 : 0) != 0);
        BlobClob4BlobTest.assertTrue((blob2 != null ? 1 : 0) != 0);
        this.commit();
        statement2.executeUpdate("update testBlob set b = b + 1 where b = 10000");
        statement.close();
        statement2.close();
        connection.commit();
        connection.close();
    }

    public void testLockingWithLongRowBlob() throws Exception {
        BlobClob4BlobTest.assertFalse((boolean)this.getConnection().getAutoCommit());
        Statement statement = this.createStatement();
        this.checkSmallPageSize(statement, "TESTBLOB");
        statement.execute("alter table testBlob add column al varchar(2000)");
        statement.execute("alter table testBlob add column bl varchar(3000)");
        statement.execute("alter table testBlob add column cl varchar(2000)");
        statement.execute("alter table testBlob add column dl varchar(3000)");
        statement.execute("alter table testBlob add column el BLOB(400k)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlob (al, bl, cl, dl, el, b) values(?,?,?,?,?,?)");
        preparedStatement.setString(1, Formatters.padString("blaaa", 2000));
        preparedStatement.setString(2, Formatters.padString("tralaaaa", 3000));
        preparedStatement.setString(3, Formatters.padString("foodar", 2000));
        preparedStatement.setString(4, Formatters.padString("moped", 3000));
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(10000L);
        preparedStatement.setBinaryStream(5, (InputStream)loopingAlphabetStream, 10000);
        preparedStatement.setInt(6, 1);
        preparedStatement.executeUpdate();
        loopingAlphabetStream.close();
        preparedStatement.close();
        this.commit();
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select el from testBlob");
        Blob blob = null;
        BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        BlobClob4BlobTest.assertTrue((String)"FAIL - blob is null", (blob != null ? 1 : 0) != 0);
        resultSet.close();
        statement.close();
        Connection connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        Statement statement2 = connection.createStatement();
        try {
            statement2.executeUpdate("update testBlob set el = null where b = 1");
            statement2.close();
            statement.close();
            connection.rollback();
            connection.close();
            BlobClob4BlobTest.fail((String)"FAIL - statement should timeout");
        }
        catch (SQLException sQLException) {
            this.checkException(LOCK_TIMEOUT, sQLException);
        }
        this.commit();
        BlobClob4BlobTest.assertTrue((String)"FAIL - blob is null after expected lock timeout", (blob != null ? 1 : 0) != 0);
        statement2.executeUpdate("update testBlob set el = null where b = 1");
        statement2.close();
        connection.commit();
        statement.close();
        connection.close();
    }

    public void testBlobAfterCommit() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testBlob");
        Blob blob = null;
        Blob blob2 = null;
        while (resultSet.next()) {
            int n = resultSet.getInt(2);
            if (n == 10000) {
                blob = resultSet.getBlob(1);
            }
            if (n != 26) continue;
            blob2 = resultSet.getBlob(1);
        }
        blob.length();
        blob2.length();
        resultSet.close();
        statement.close();
        this.commit();
        BlobClob4BlobTest.assertTrue((String)"FAIL - shortBlob is NULL", (blob2 != null ? 1 : 0) != 0);
        try {
            blob2.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access Blob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        BlobClob4BlobTest.assertTrue((String)"FAIL - blob is NULL", (blob != null ? 1 : 0) != 0);
        try {
            blob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            blob.getBytes(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            blob.getBinaryStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            blob.position("foo".getBytes("US-ASCII"), 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
        try {
            blob.position(blob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException sQLException) {
            this.checkException(INVALID_LOB, sQLException);
        }
    }

    public void testBlobAfterClosingConnection() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testBlob");
        Blob blob = null;
        Blob blob2 = null;
        while (resultSet.next()) {
            int n = resultSet.getInt(2);
            if (n == 10000) {
                blob = resultSet.getBlob(1);
            }
            if (n != 26) continue;
            blob2 = resultSet.getBlob(1);
        }
        blob.length();
        blob2.length();
        resultSet.close();
        this.rollback();
        this.getConnection().close();
        try {
            long l = blob2.length();
            BlobClob4BlobTest.fail((String)"FAIL - should get an exception, connection is closed");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            blob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            blob.getBytes(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            blob.getBinaryStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            blob.position("foo".getBytes("US-ASCII"), 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        try {
            blob.position(blob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException sQLException) {
            this.checkException(NO_CURRENT_CONNECTION, sQLException);
        }
        this.getConnection().setAutoCommit(false);
    }

    public void testBlobFinalizer() throws Exception {
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a,b from testBlob");
        Blob[] blobArray = new Blob[10];
        int[] nArray = new int[10];
        int n = 0;
        while (resultSet.next()) {
            blobArray[n] = resultSet.getBlob(1);
            nArray[n++] = resultSet.getInt(2);
        }
        resultSet.close();
        statement.close();
        for (int i = 0; i < 10; ++i) {
            blobArray[i] = null;
        }
        System.gc();
        System.gc();
    }

    public void testGetBlobBeforeAndAfterUpdate() throws Exception {
        String string = "initial blob ";
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setBytes(2, (string + i).getBytes("US-ASCII"));
            preparedStatement.execute();
        }
        preparedStatement.close();
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT b, a FROM testBlob");
        resultSet.first();
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.next();
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.relative(3);
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.absolute(7);
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.previous();
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.last();
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.previous();
        this.checkContentsBeforeAndAfterUpdatingBlob(resultSet);
        resultSet.close();
        statement.close();
    }

    private void checkContentsBeforeAndAfterUpdatingBlob(ResultSet resultSet) throws SQLException, UnsupportedEncodingException {
        String string = "initial blob ";
        String string2 = "updated blob ";
        Blob blob = resultSet.getBlob(2);
        byte[] byArray = blob.getBytes(1L, string.length() + 1);
        byte[] byArray2 = (string + resultSet.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(byArray, byArray2));
        byArray = (string2 + resultSet.getInt(1)).getBytes("US-ASCII");
        blob.setBytes(1L, byArray);
        resultSet.updateBlob(2, blob);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        blob = resultSet.getBlob(2);
        byArray = blob.getBytes(1L, string2.length() + 1);
        byArray2 = (string2 + resultSet.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testGetBlobBeforeAndAfterUpdateStream() throws Exception {
        String string = "initial blob ";
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setBytes(2, (string + i).getBytes("US-ASCII"));
            preparedStatement.execute();
        }
        preparedStatement.close();
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT b, a FROM testBlob");
        resultSet.first();
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.next();
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.relative(3);
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.absolute(7);
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.previous();
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.last();
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.previous();
        this.updateBlobWithUpdateBinaryStream(resultSet);
        resultSet.close();
        statement.close();
    }

    private void updateBlobWithUpdateBinaryStream(ResultSet resultSet) throws SQLException, UnsupportedEncodingException {
        String string = "initial blob ";
        String string2 = "updated blob ";
        Blob blob = resultSet.getBlob(2);
        byte[] byArray = blob.getBytes(1L, string.length() + 1);
        byte[] byArray2 = (string + resultSet.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(byArray, byArray2));
        byArray = (string2 + resultSet.getInt(1)).getBytes("US-ASCII");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        resultSet.updateBinaryStream(2, (InputStream)byteArrayInputStream, byArray.length);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        blob = resultSet.getBlob(2);
        byArray = blob.getBytes(1L, string2.length() + 1);
        byArray2 = (string2 + resultSet.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testSelfDestructiveClob() throws Exception {
        int n;
        this.insertDefaultData();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a, b from testClob where b = 10000");
        byte[] byArray = new byte[128];
        Clob clob = null;
        int n2 = 0;
        int n3 = 0;
        BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        ++n3;
        n2 = resultSet.getInt(2);
        clob = resultSet.getClob(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (int)10000, (int)n2);
        InputStream inputStream = clob.getAsciiStream();
        int n4 = 0;
        PreparedStatement preparedStatement = this.prepareStatement("update testClob set a = ? where b = 10000");
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < 1000; ++n) {
            stringBuffer.append('j');
        }
        preparedStatement.setString(1, stringBuffer.toString());
        preparedStatement.executeUpdate();
        resultSet = statement.executeQuery("select a from testClob where b = 10000");
        while (resultSet.next()) {
            n = 1;
            String string = resultSet.getString(1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - invalid blob value", (String)stringBuffer.substring(0, 50), (String)string.substring(0, 50));
            ++n;
        }
        while (n4 < 11000 && (n = inputStream.read(byArray)) != -1) {
            n4 += n;
        }
        BlobClob4BlobTest.assertEquals((String)"FAIL - invalid column size", (int)10000, (int)n4);
        BlobClob4BlobTest.assertEquals((String)"FAIL - invalid column size", (int)n2, (int)n4);
        BlobClob4BlobTest.assertEquals((String)"FAIL - invalid column size", (long)n4, (long)clob.length());
        resultSet.close();
        statement.close();
    }

    public void testSelfDestructiveClob2() throws Exception {
        block3: {
            this.insertDefaultData();
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("select a,b from testClob where b = 10000");
            byte[] byArray = new byte[128];
            Clob clob = null;
            int n = 0;
            int n2 = 0;
            BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
            ++n2;
            n = resultSet.getInt(2);
            clob = resultSet.getClob(1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (int)10000, (int)n);
            InputStream inputStream = clob.getAsciiStream();
            statement.executeUpdate("drop table testClob");
            try {
                int n3;
                for (int i = 0; i < 11000 && (n3 = inputStream.read(byArray)) != -1; i += n3) {
                }
                BlobClob4BlobTest.fail((String)"FAIL - should have got an IOException");
            }
            catch (IOException iOException) {
                if (!BlobClob4BlobTest.usingEmbedded()) break block3;
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong exception", (String)"ERROR 40XD0: Container has been closed.", (String)iOException.getMessage());
            }
        }
        this.rollback();
    }

    public void testNegativeTestDerby265Blob() throws Exception {
        AutoCloseable autoCloseable;
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlob(b, a) values(?,?)");
        for (int i = 0; i < 3; ++i) {
            autoCloseable = new LoopingAlphabetStream(300000L);
            preparedStatement.setInt(1, i);
            preparedStatement.setBinaryStream(2, (InputStream)autoCloseable, 300000);
            preparedStatement.executeUpdate();
            ((InputStream)autoCloseable).close();
        }
        this.commit();
        this.getConnection().setAutoCommit(true);
        Statement statement = this.createStatement(1003, 1007);
        statement.execute("SELECT b, a FROM testBlob");
        autoCloseable = statement.getResultSet();
        Statement statement2 = this.createStatement(1003, 1007);
        statement2.executeQuery("SELECT b, a FROM testBlob");
        ResultSet resultSet = statement2.getResultSet();
        resultSet.next();
        Blob blob = resultSet.getBlob(2);
        autoCloseable.next();
        Blob blob2 = autoCloseable.getBlob(2);
        autoCloseable.close();
        BlobClob4BlobTest.assertTrue((boolean)resultSet.next());
        BlobClob4BlobTest.assertNotNull((Object)resultSet.getBlob(2));
        resultSet.close();
    }

    public void testNegativeTestDerby265Clob() throws Exception {
        AutoCloseable autoCloseable;
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into testClob(b, a) values(?,?)");
        for (int i = 0; i < 3; ++i) {
            autoCloseable = new LoopingAlphabetReader(300000L);
            preparedStatement.setInt(1, i);
            preparedStatement.setCharacterStream(2, (Reader)autoCloseable, 300000);
            preparedStatement.executeUpdate();
            ((Reader)autoCloseable).close();
        }
        this.commit();
        this.getConnection().setAutoCommit(true);
        Statement statement = this.createStatement(1003, 1007);
        statement.execute("SELECT b, a FROM testClob");
        autoCloseable = statement.getResultSet();
        Statement statement2 = this.createStatement(1003, 1007);
        statement2.executeQuery("SELECT b, a FROM testClob");
        ResultSet resultSet = statement2.getResultSet();
        resultSet.next();
        Clob clob = resultSet.getClob(2);
        autoCloseable.next();
        Clob clob2 = autoCloseable.getClob(2);
        autoCloseable.close();
        BlobClob4BlobTest.assertTrue((boolean)resultSet.next());
        BlobClob4BlobTest.assertNotNull((Object)resultSet.getClob(2));
        resultSet.close();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("BlobClob4BlobTest");
        baseTestSuite.addTest(BlobClob4BlobTest.baseSuite("embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(BlobClob4BlobTest.baseSuite("client")));
        if (JDBC.vmSupportsJDBC3()) {
            Test test = BlobClob4BlobTest.baseSuite("encrypted");
            baseTestSuite.addTest(Decorator.encryptedDatabase(test));
        }
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(BlobClob4BlobTest.class, "BlobClob4BlobTest:" + string);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4));
    }

    private void insertDefaultData() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testClob (a, b, c) VALUES (?, ?, ?)");
        String string = "";
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, string.length());
        preparedStatement.setLong(3, 0L);
        preparedStatement.addBatch();
        string = "you can lead a horse to water but you can't form it into beverage";
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, string.length());
        preparedStatement.setLong(3, 0L);
        preparedStatement.addBatch();
        string = "a stitch in time says ouch";
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, string.length());
        preparedStatement.setLong(3, 0L);
        preparedStatement.addBatch();
        string = "here is a string with a return \n character";
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, string.length());
        preparedStatement.setLong(3, 0L);
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.clearBatch();
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.modernLatinLowercase(), 0);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.modernLatinLowercase(), 56);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.modernLatinLowercase(), 5000);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.modernLatinLowercase(), 10000);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.modernLatinLowercase(), 300000);
        preparedStatement.setNull(1, 2005);
        preparedStatement.setInt(2, 0);
        preparedStatement.setLong(3, 0L);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("INSERT INTO testBlob (a, b, crc32) VALUES (?, ?, ?)");
        byte[] byArray = "".getBytes("US-ASCII");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setInt(2, byArray.length);
        preparedStatement.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(byArray)));
        preparedStatement.addBatch();
        byArray = "you can lead a horse to water but you can't form it into beverage".getBytes("US-ASCII");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setInt(2, byArray.length);
        preparedStatement.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(byArray)));
        preparedStatement.addBatch();
        byArray = "a stitch in time says ouch".getBytes("US-ASCII");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setInt(2, byArray.length);
        preparedStatement.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(byArray)));
        preparedStatement.addBatch();
        byArray = "here is a string with a return \n character".getBytes("US-ASCII");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setInt(2, byArray.length);
        preparedStatement.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(byArray)));
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.clearBatch();
        this.insertLoopingAlphabetStreamData(preparedStatement, 0);
        this.insertLoopingAlphabetStreamData(preparedStatement, 56);
        this.insertLoopingAlphabetStreamData(preparedStatement, 5000);
        this.insertLoopingAlphabetStreamData(preparedStatement, 10000);
        this.insertLoopingAlphabetStreamData(preparedStatement, 300000);
        preparedStatement.setNull(1, 2004);
        preparedStatement.setInt(2, 0);
        preparedStatement.setNull(3, -5);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.commit();
    }

    private void insertUnicodeData(String[] stringArray) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testClob (a, b, c) VALUES (?, ?, ?)");
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            preparedStatement.setInt(2, stringArray[i].length());
            preparedStatement.setInt(3, i);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.clearBatch();
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.tamil(), 0);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.tamil(), 56);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.tamil(), 5000);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.tamil(), 10000);
        this.insertLoopingAlphabetStreamData(preparedStatement, CharAlphabet.tamil(), 300000);
        preparedStatement.setNull(1, 2005);
        preparedStatement.setInt(2, 0);
        preparedStatement.setInt(3, -1);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.commit();
    }

    private void insertLoopingAlphabetStreamData(PreparedStatement preparedStatement, int n) throws Exception {
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n), n);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, this.getStreamCheckSum(new LoopingAlphabetStream(n)));
        preparedStatement.executeUpdate();
    }

    private void insertLoopingAlphabetStreamData(PreparedStatement preparedStatement, CharAlphabet charAlphabet, int n) throws Exception {
        preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, -1L);
        preparedStatement.executeUpdate();
    }

    private boolean compareReaders(Reader reader, Reader reader2) throws Exception {
        char[] cArray = new char[1024];
        char[] cArray2 = new char[1024];
        int n = -1;
        int n2 = -1;
        do {
            if ((n = reader.read(cArray)) != (n2 = reader2.read(cArray2))) {
                return false;
            }
            if (Arrays.equals(cArray, cArray2)) continue;
            return false;
        } while (n != -1);
        return true;
    }

    private long getStreamCheckSum(InputStream inputStream) throws Exception {
        int n;
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) != -1) {
            cRC32.update(byArray, 0, n);
        }
        inputStream.close();
        return cRC32.getValue();
    }

    private void verifyInterval(Clob clob, long l, int n, int n2, int n3) throws Exception {
        try {
            int n4;
            String string = clob.getSubString(l, n);
            BlobClob4BlobTest.assertEquals((String)"FAIL - getSubString returned wrong length", (long)Math.min(clob.length() - l + 1L, (long)n), (long)string.length());
            BlobClob4BlobTest.assertEquals((String)"FAIL - clob has mismatched lengths", (long)n3, (long)clob.length());
            BlobClob4BlobTest.assertFalse((String)"FAIL - NO ERROR ON getSubString POS TOO LARGE", (l > (long)(n3 + 1) ? 1 : 0) != 0);
            char[] cArray = new char[n];
            Reader reader = clob.getCharacterStream();
            long l2 = 0L;
            if (n3 > 0) {
                BlobClob4BlobTest.println("clobLength: " + n3);
                for (long i = l - 1L; i > 0L && l2 >= 0L; i -= (l2 = reader.skip(Math.min(1024L, i))) > 0L ? l2 : 0L) {
                }
            }
            if ((n4 = reader.read(cArray)) >= 0) {
                char[] cArray2 = new char[n4];
                System.arraycopy(cArray, 0, cArray2, 0, n4);
                String string2 = new String(cArray2);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring value", (String)string2, (String)string);
            } else {
                BlobClob4BlobTest.assertTrue((String)"FAIL - wrong length", (string.length() == 0 ? 1 : 0) != 0);
            }
        }
        catch (SQLException sQLException) {
            if (l <= 0L) {
                this.checkException(BLOB_BAD_POSITION, sQLException);
            }
            if (l > (long)(n3 + 1)) {
                this.checkException(BLOB_POSITION_TOO_LARGE, sQLException);
            }
            throw sQLException;
        }
    }

    private void verifyInterval(Blob blob, long l, int n, int n2, int n3) throws Exception {
        try {
            String string = new String(blob.getBytes(l, n), "US-ASCII");
            BlobClob4BlobTest.assertEquals((String)"FAIL - getSubString returned wrong length ", (long)Math.min(blob.length() - l + 1L, (long)n), (long)string.length());
            BlobClob4BlobTest.assertEquals((String)"FAIL - clob has mismatched lengths", (long)n3, (long)blob.length());
            BlobClob4BlobTest.assertFalse((String)"FAIL - NO ERROR ON getSubString POS TOO LARGE", (l > (long)(n3 + 1) ? 1 : 0) != 0);
            byte[] byArray = new byte[n];
            InputStream inputStream = blob.getBinaryStream();
            inputStream.skip(l - 1L);
            int n4 = inputStream.read(byArray);
            if (n4 >= 0) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
                String string2 = new String(byArray2, "US-ASCII");
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring value", (String)string2, (String)string);
            } else {
                BlobClob4BlobTest.assertTrue((String)"FAIL - wrong length", (string.length() == 0 ? 1 : 0) != 0);
            }
        }
        catch (SQLException sQLException) {
            if (l <= 0L) {
                this.checkException(BLOB_BAD_POSITION, sQLException);
            }
            if (l > (long)(n3 + 1)) {
                this.checkException(BLOB_POSITION_TOO_LARGE, sQLException);
            }
            throw sQLException;
        }
    }

    public void testBlobContents(ResultSet resultSet) throws Exception {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[128];
        int n3 = 0;
        int n4 = 0;
        while (resultSet.next()) {
            int n5;
            ++n4;
            Blob blob = resultSet.getBlob(1);
            long l = resultSet.getLong(3);
            boolean bl = resultSet.wasNull();
            if (blob == null) {
                BlobClob4BlobTest.assertTrue((String)"FAIL - NULL BLOB but non-NULL checksum", (boolean)bl);
                ++n;
                continue;
            }
            ++n2;
            long l2 = this.getStreamCheckSum(blob.getBinaryStream());
            BlobClob4BlobTest.assertEquals((String)("FAIL - mismatched checksums for blob with length " + blob.length()), (long)l2, (long)l);
            InputStream inputStream = blob.getBinaryStream();
            int n6 = 0;
            while ((n5 = inputStream.read(byArray)) != -1) {
                n6 += n5;
            }
            n3 = resultSet.getInt(2);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)n3, (int)n6);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column length", (long)n3, (long)blob.length());
        }
        BlobClob4BlobTest.assertEquals((String)("FAIL - wrong not null row count null:" + n), (int)9, (int)n2);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong null blob count", (int)1, (int)n);
    }

    public void testBlobInsert() throws SQLException {
        String[] stringArray = new String[]{"int", "char(10)", "varchar(80)", "long varchar", "char(10) for bit data", "long varchar for bit data", "blob(80)"};
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create table blobCheck (bl blob(80)) ");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].indexOf("blob") == -1) continue;
            Object object = "insert into blobCheck (bl ) values ('string' )";
            BlobClob4BlobTest.assertStatementError("42821", statement, (String)object);
            object = "insert into blobCheck (bl ) values (cast (" + Utilities.stringToHexLiteral("string") + " as blob(80)) )";
            statement.execute((String)object);
            object = "insert into blobCheck (bl ) values (X'48' )";
            BlobClob4BlobTest.assertStatementError("42821", statement, (String)object);
            object = "insert into blobCheck (bl ) values (cast (X'C8' as blob(80)) )";
            statement.execute((String)object);
            object = "insert into blobCheck (bl ) values ( X'a78a' )";
            BlobClob4BlobTest.assertStatementError("42821", statement, (String)object);
            object = "insert into blobCheck (bl ) values (cast (X'a78a' as blob(80)) )";
            statement.execute((String)object);
        }
        statement.execute("drop table blobCheck");
    }

    private void checkException(String string, SQLException sQLException) throws Exception {
        BlobClob4BlobTest.assertSQLState(string, sQLException);
    }

    public void testRetrieveMoreThan32KLobs() throws SQLException {
        int n = 34000;
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO TESTCLOB VALUES(?,?,?)");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.setString(3, "" + i);
            preparedStatement.executeUpdate();
            if (i % 1000 != 0) continue;
            this.commit();
        }
        this.commit();
        ResultSet resultSet = statement.executeQuery("SELECT * from TESTCLOB");
        while (resultSet.next()) {
            resultSet.getInt(1);
            Clob clob = resultSet.getClob(3);
            clob.getSubString(1L, 100);
        }
        resultSet.close();
        connection.commit();
    }

    public void testDerby5113() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into testblob(a) values ?");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(5000L), 5000);
        preparedStatement.executeUpdate();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a from testblob");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        byte[] byArray = blob.getBytes(1L, 3000);
        BlobClob4BlobTest.assertEquals(new LoopingAlphabetStream(3000L), new ByteArrayInputStream(byArray));
        blob.truncate(4000L);
        BlobClob4BlobTest.assertEquals((long)4000L, (long)blob.length());
        byArray = blob.getBytes(1L, 4000);
        BlobClob4BlobTest.assertEquals(new LoopingAlphabetStream(4000L), new ByteArrayInputStream(byArray));
        resultSet.close();
    }

    private void checkSmallPageSize(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('" + string + "')) T");
        int n = 0;
        while (resultSet.next()) {
            ++n;
            BlobClob4BlobTest.assertEquals((int)4096, (int)resultSet.getInt("pagesize"));
        }
        BlobClob4BlobTest.assertTrue((n == 1 ? 1 : 0) != 0);
        resultSet.close();
    }
}

