/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.JoinResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class MergeJoinResultSet
extends JoinResultSet {
    private static final int GREATER_THAN = 1;
    private static final int EQUAL = 0;
    private static final int LESS_THAN = -1;
    private GeneratedMethod leftGreaterThanRight;

    MergeJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod leftGreaterThanRight, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, null);
        this.leftGreaterThanRight = leftGreaterThanRight;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (!this.isRightOpen) {
            this.openRight();
        }
        while (this.leftRow != null) {
            int compareResult;
            while ((compareResult = ((Integer)this.leftGreaterThanRight.invoke(this.activation)).intValue()) == 1) {
                this.rightRow = this.rightResultSet.getNextRowCore();
                ++this.rowsSeenRight;
                if (this.rightRow != null) continue;
                this.clearCurrentRow();
                return null;
            }
            if (compareResult == 0 && this.restrictionIsTrue()) {
                ExecRow returnRow = this.getReturnRow(this.leftRow, this.rightRow);
                this.leftRow = this.leftResultSet.getNextRowCore();
                return returnRow;
            }
            this.leftRow = this.leftResultSet.getNextRowCore();
            ++this.rowsSeenLeft;
        }
        this.clearCurrentRow();
        return null;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "MergeJoinResultSet not open");
        if (this.isOpen) {
            this.clearCurrentRow();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.leftResultSet.getTimeSpent(1) - this.rightResultSet.getTimeSpent(1);
        }
        return totTime;
    }

    private ExecRow getReturnRow(ExecRow leftRow, ExecRow rightRow) throws StandardException {
        DataValueDescriptor src_col;
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
        }
        int colInCtr = 1;
        int colOutCtr = 1;
        while (colInCtr <= this.leftNumCols) {
            src_col = leftRow.getColumn(colInCtr);
            if (src_col != null && src_col.hasStream()) {
                src_col = src_col.cloneValue(false);
            }
            this.mergedRow.setColumn(colOutCtr, src_col);
            ++colInCtr;
            ++colOutCtr;
        }
        colInCtr = 1;
        while (colInCtr <= this.rightNumCols) {
            src_col = rightRow.getColumn(colInCtr);
            if (src_col != null && src_col.hasStream()) {
                src_col = src_col.cloneValue(false);
            }
            this.mergedRow.setColumn(colOutCtr, src_col);
            ++colInCtr;
            ++colOutCtr;
        }
        this.setCurrentRow(this.mergedRow);
        ++this.rowsReturned;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return this.mergedRow;
    }

    private boolean restrictionIsTrue() throws StandardException {
        DataValueDescriptor restrictBoolean;
        if (this.restriction != null && ((restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation)).isNull() || !restrictBoolean.getBoolean())) {
            ++this.rowsFiltered;
            return false;
        }
        return true;
    }
}

