/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.log.ChecksumOperation;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class Scan
implements StreamLogScan {
    public static final byte FORWARD = 1;
    public static final byte BACKWARD = 2;
    public static final byte BACKWARD_FROM_LOG_END = 4;
    private StorageRandomAccessFile scan;
    private LogToFile logFactory;
    private long currentLogFileNumber;
    private long currentLogFileLength;
    private long knownGoodLogEnd;
    private long currentInstant;
    private long stopAt;
    private byte scanDirection;
    private boolean fuzzyLogEnd = false;

    public Scan(LogToFile logFactory, long startAt, LogInstant stopAt, byte direction) throws IOException, StandardException {
        SanityManager.ASSERT(startAt != 0L, "cannot start scan on an invalid log instant");
        this.logFactory = logFactory;
        this.currentLogFileNumber = LogCounter.getLogFileNumber(startAt);
        this.currentLogFileLength = -1L;
        this.knownGoodLogEnd = 0L;
        this.currentInstant = 0L;
        this.stopAt = stopAt != null ? ((LogCounter)stopAt).getValueAsLong() : 0L;
        switch (direction) {
            case 1: {
                this.scan = logFactory.getLogFileAtPosition(startAt);
                this.scanDirection = 1;
                if (this.scan == null) {
                    SanityManager.THROWASSERT("scan null at " + LogCounter.toDebugString(startAt));
                }
                this.currentLogFileLength = this.scan.length();
                break;
            }
            case 2: {
                this.scan = logFactory.getLogFileAtPosition(startAt);
                int logsize = this.scan.readInt();
                this.scan.seek(this.scan.getFilePointer() + (long)logsize + 16L - 4L);
                this.scanDirection = (byte)2;
                break;
            }
            case 4: {
                this.scan = logFactory.getLogFileAtPosition(startAt);
                this.scanDirection = (byte)2;
            }
        }
    }

    @Override
    public LogRecord getNextRecord(ArrayInputStream input, TransactionId tranId, int groupmask) throws StandardException {
        if (this.scan == null) {
            return null;
        }
        SanityManager.ASSERT(this.scanDirection != 0, "scan has been secretly closed!");
        LogRecord lr = null;
        try {
            if (this.scanDirection == 2) {
                lr = this.getNextRecordBackward(input, tranId, groupmask);
            } else if (this.scanDirection == 1) {
                lr = this.getNextRecordForward(input, tranId, groupmask);
            }
            LogRecord logRecord = lr;
            return logRecord;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", ioe, new Object[0]));
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", cnfe, new Object[0]));
        }
        finally {
            if (lr == null) {
                this.close();
            }
        }
    }

    private LogRecord getNextRecordBackward(ArrayInputStream input, TransactionId tranId, int groupmask) throws StandardException, IOException, ClassNotFoundException {
        LogRecord lr;
        boolean candidate;
        SanityManager.ASSERT(this.scanDirection == 2, "can only called by backward scan");
        int peekAmount = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
        if (tranId != null) {
            peekAmount += LogRecord.maxTransactionIdStoredSize(tranId);
        }
        long curpos = this.scan.getFilePointer();
        do {
            candidate = true;
            lr = null;
            int readAmount = -1;
            if (curpos == 24L) {
                if (this.stopAt != 0L && LogCounter.getLogFileNumber(this.stopAt) == this.currentLogFileNumber) {
                    if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "stopping at " + this.currentLogFileNumber);
                    }
                    return null;
                }
                this.scan.seek(16L);
                long previousLogInstant = this.scan.readLong();
                this.scan.close();
                SanityManager.ASSERT(previousLogInstant != 0L, "scanning backward beyond the first log file");
                if (this.currentLogFileNumber != LogCounter.getLogFileNumber(previousLogInstant) + 1L) {
                    SanityManager.THROWASSERT("scanning backward but get incorrect log file number expected " + (this.currentLogFileNumber - 1L) + "get " + LogCounter.getLogFileNumber(previousLogInstant));
                }
                SanityManager.ASSERT(LogCounter.getLogFilePosition(previousLogInstant) > 24L, "scanning backward encounter completely empty log file");
                SanityManager.DEBUG(LogToFile.DBG_FLAG, "scanning backwards from log file " + this.currentLogFileNumber + ", switch to (" + LogCounter.getLogFileNumber(previousLogInstant) + "," + LogCounter.getLogFilePosition(previousLogInstant) + ")");
                this.currentLogFileNumber = LogCounter.getLogFileNumber(previousLogInstant);
                this.scan = this.logFactory.getLogFileAtPosition(previousLogInstant);
                curpos = this.scan.getFilePointer();
                if (curpos == 24L) continue;
            }
            this.scan.seek(curpos - 4L);
            int recordLength = this.scan.readInt();
            long recordStartPosition = curpos - (long)recordLength - 16L;
            if (recordStartPosition < 24L) {
                SanityManager.THROWASSERT("next position " + recordStartPosition + " recordLength " + recordLength + " current file position " + this.scan.getFilePointer());
            }
            this.scan.seek(recordStartPosition);
            int checkLength = this.scan.readInt();
            if (checkLength != recordLength) {
                long inst = LogCounter.makeLogInstantAsLong(this.currentLogFileNumber, recordStartPosition);
                throw this.logFactory.markCorrupt(StandardException.newException("XSLAD.D", checkLength, recordLength, inst, this.currentLogFileNumber));
            }
            this.currentInstant = this.scan.readLong();
            if (LogCounter.getLogFileNumber(this.currentInstant) != this.currentLogFileNumber || LogCounter.getLogFilePosition(this.currentInstant) != recordStartPosition) {
                SanityManager.THROWASSERT("Wrong LogInstant on log record " + LogCounter.toDebugString(this.currentInstant) + " version real position (" + this.currentLogFileNumber + "," + recordStartPosition + ")");
            }
            if (this.currentInstant < this.stopAt && this.stopAt != 0L) {
                this.currentInstant = 0L;
                return null;
            }
            byte[] data = input.getData();
            if (data.length < recordLength) {
                data = new byte[recordLength];
                input.setData(data);
            }
            if (this.logFactory.databaseEncrypted()) {
                this.scan.readFully(data, 0, recordLength);
                int len = this.logFactory.decrypt(data, 0, recordLength, data, 0);
                SanityManager.ASSERT(len == recordLength);
                input.setLimit(0, recordLength);
            } else if (groupmask == 0 && tranId == null) {
                this.scan.readFully(data, 0, recordLength);
                input.setLimit(0, recordLength);
            } else {
                readAmount = recordLength > peekAmount ? peekAmount : recordLength;
                this.scan.readFully(data, 0, readAmount);
                input.setLimit(0, readAmount);
            }
            lr = (LogRecord)input.readObject();
            if (lr.isChecksum()) {
                candidate = false;
            } else if (groupmask != 0 || tranId != null) {
                TransactionId tid;
                if (lr.isChecksum()) {
                    candidate = false;
                }
                if (candidate && groupmask != 0 && (groupmask & lr.group()) == 0) {
                    candidate = false;
                }
                if (candidate && tranId != null && !(tid = lr.getTransactionId()).equals(tranId)) {
                    candidate = false;
                }
                if (candidate && !this.logFactory.databaseEncrypted()) {
                    SanityManager.ASSERT(readAmount > 0);
                    if (readAmount < recordLength) {
                        int inputPosition = input.getPosition();
                        this.scan.readFully(data, readAmount, recordLength - readAmount);
                        input.setLimit(0, recordLength);
                        input.setPosition(inputPosition);
                    }
                }
            }
            curpos = recordStartPosition;
            this.scan.seek(curpos);
        } while (!candidate);
        return lr;
    }

    private LogRecord getNextRecordForward(ArrayInputStream input, TransactionId tranId, int groupmask) throws StandardException, IOException, ClassNotFoundException {
        LogRecord lr;
        boolean candidate;
        SanityManager.ASSERT(this.scanDirection == 1, "can only called by forward scan");
        long recordStartPosition = this.scan.getFilePointer();
        int peekAmount = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
        if (tranId != null) {
            peekAmount += LogRecord.maxTransactionIdStoredSize(tranId);
        }
        do {
            ChecksumOperation clop;
            int ckDataLength;
            int checkLength;
            candidate = true;
            lr = null;
            int readAmount = -1;
            if (recordStartPosition + 4L > this.currentLogFileLength) {
                if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                    SanityManager.DEBUG(LogToFile.DBG_FLAG, "detected fuzzy log end on log file " + this.currentLogFileNumber + " record start position " + recordStartPosition + " file length " + this.currentLogFileLength);
                }
                if (recordStartPosition != this.currentLogFileLength) {
                    this.fuzzyLogEnd = true;
                }
                return null;
            }
            int recordLength = this.scan.readInt();
            while (recordLength == 0 || recordStartPosition + (long)recordLength + 16L > this.currentLogFileLength) {
                if (recordLength != 0) {
                    if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "detected fuzzy log end on log file " + this.currentLogFileNumber + " record start position " + recordStartPosition + " file length " + this.currentLogFileLength + " recordLength=" + recordLength);
                    }
                    this.fuzzyLogEnd = true;
                    this.scan.close();
                    this.scan = null;
                    return null;
                }
                if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                    if (recordStartPosition + 4L == this.currentLogFileLength) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "detected proper log end on log file " + this.currentLogFileNumber);
                    } else {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "detected zapped log end on log file " + this.currentLogFileNumber + " end marker at " + recordStartPosition + " real end at " + this.currentLogFileLength);
                    }
                }
                if (this.stopAt != 0L && LogCounter.getLogFileNumber(this.stopAt) == this.currentLogFileNumber) {
                    return null;
                }
                this.scan.close();
                this.scan = this.logFactory.getLogFileAtBeginning(++this.currentLogFileNumber);
                if (this.scan == null) {
                    return null;
                }
                recordStartPosition = this.scan.getFilePointer();
                this.scan.seek(16L);
                long previousLogInstant = this.scan.readLong();
                if (previousLogInstant != this.knownGoodLogEnd) {
                    if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "log file " + this.currentLogFileNumber + ": previous log record: " + previousLogInstant + " known previous log record: " + this.knownGoodLogEnd);
                    }
                    return null;
                }
                this.scan.seek(recordStartPosition);
                if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                    SanityManager.DEBUG(LogToFile.DBG_FLAG, "switched to next log file " + this.currentLogFileNumber);
                }
                this.knownGoodLogEnd = LogCounter.makeLogInstantAsLong(this.currentLogFileNumber, recordStartPosition);
                this.currentLogFileLength = this.scan.length();
                if (recordStartPosition + 4L >= this.currentLogFileLength) {
                    if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "log file " + this.currentLogFileNumber + " is empty");
                    }
                    return null;
                }
                recordLength = this.scan.readInt();
            }
            this.currentInstant = this.scan.readLong();
            if (this.currentInstant < this.knownGoodLogEnd) {
                this.fuzzyLogEnd = true;
                return null;
            }
            if (LogCounter.getLogFileNumber(this.currentInstant) != this.currentLogFileNumber || LogCounter.getLogFilePosition(this.currentInstant) != recordStartPosition) {
                SanityManager.THROWASSERT("Wrong LogInstant on log record " + LogCounter.toDebugString(this.currentInstant) + " version real position (" + this.currentLogFileNumber + "," + recordStartPosition + ")");
            }
            if (this.stopAt != 0L && this.currentInstant > this.stopAt) {
                this.currentInstant = 0L;
                return null;
            }
            byte[] data = input.getData();
            if (data.length < recordLength) {
                data = new byte[recordLength];
                input.setData(data);
            }
            if (this.logFactory.databaseEncrypted()) {
                this.scan.readFully(data, 0, recordLength);
                int len = this.logFactory.decrypt(data, 0, recordLength, data, 0);
                SanityManager.ASSERT(len == recordLength);
                input.setLimit(0, len);
            } else if (groupmask == 0 && tranId == null) {
                this.scan.readFully(data, 0, recordLength);
                input.setLimit(0, recordLength);
            } else {
                readAmount = recordLength > peekAmount ? peekAmount : recordLength;
                this.scan.readFully(data, 0, readAmount);
                input.setLimit(0, readAmount);
            }
            lr = (LogRecord)input.readObject();
            if (groupmask != 0 || tranId != null) {
                TransactionId tid;
                if (groupmask != 0 && (groupmask & lr.group()) == 0) {
                    candidate = false;
                }
                if (candidate && tranId != null && !(tid = lr.getTransactionId()).equals(tranId)) {
                    candidate = false;
                }
                if (candidate && !this.logFactory.databaseEncrypted()) {
                    SanityManager.ASSERT(readAmount > 0);
                    if (readAmount < recordLength) {
                        int inputPosition = input.getPosition();
                        this.scan.readFully(data, readAmount, recordLength - readAmount);
                        input.setLimit(0, recordLength);
                        input.setPosition(inputPosition);
                    }
                }
            }
            if (!candidate) {
                this.scan.seek(recordStartPosition - 4L);
            }
            if ((checkLength = this.scan.readInt()) != recordLength && checkLength < recordLength) {
                if (checkLength < recordLength) {
                    this.fuzzyLogEnd = true;
                    return null;
                }
                throw this.logFactory.markCorrupt(StandardException.newException("XSLAD.D", checkLength, recordLength, this.currentInstant, this.currentLogFileNumber));
            }
            this.knownGoodLogEnd = LogCounter.makeLogInstantAsLong(this.currentLogFileNumber, recordStartPosition += (long)(recordLength + 16));
            if (recordStartPosition != this.scan.getFilePointer()) {
                SanityManager.THROWASSERT("calculated end " + recordStartPosition + " != real end " + this.scan.getFilePointer());
            }
            if (!lr.isChecksum()) continue;
            candidate = false;
            Loggable op = lr.getLoggable();
            if (SanityManager.DEBUG_ON(LogToFile.DUMP_LOG_ONLY) || SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                SanityManager.DEBUG(LogToFile.DBG_FLAG, "scanned Null : " + String.valueOf(op) + " instant = " + LogCounter.toDebugString(this.currentInstant) + " logEnd = " + LogCounter.toDebugString(this.knownGoodLogEnd));
            }
            if (data.length < (ckDataLength = (clop = (ChecksumOperation)op).getDataLength())) {
                data = new byte[ckDataLength];
                input.setData(data);
                input.setLimit(0, ckDataLength);
            }
            boolean validChecksum = false;
            if (recordStartPosition + (long)ckDataLength <= this.currentLogFileLength) {
                this.scan.readFully(data, 0, ckDataLength);
                if (clop.isChecksumValid(data, 0, ckDataLength)) {
                    validChecksum = true;
                }
            }
            if (!validChecksum) {
                if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                    SanityManager.DEBUG(LogToFile.DBG_FLAG, "detected fuzzy log end on log file while doing checksum checks " + this.currentLogFileNumber + " checksum record start position " + recordStartPosition + " file length " + this.currentLogFileLength + " checksumDataLength=" + ckDataLength);
                }
                this.fuzzyLogEnd = true;
                this.scan.close();
                this.scan = null;
                return null;
            }
            this.scan.seek(recordStartPosition);
        } while (!candidate);
        return lr;
    }

    @Override
    public void resetPosition(LogInstant instant) throws IOException, StandardException {
        SanityManager.ASSERT(instant != null);
        long instant_long = ((LogCounter)instant).getValueAsLong();
        if (instant_long == 0L || this.stopAt != 0L && this.scanDirection == 1 && instant_long > this.stopAt || this.scanDirection == 1 && instant_long < this.stopAt) {
            this.close();
            throw StandardException.newException("XSLB8.S", instant, new LogCounter(this.stopAt));
        }
        long fnum = ((LogCounter)instant).getLogFileNumber();
        if (fnum != this.currentLogFileNumber) {
            if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                SanityManager.DEBUG(LogToFile.DBG_FLAG, "Scan " + this.scanDirection + " resetting to " + String.valueOf(instant) + " need to switch log from " + this.currentLogFileNumber + " to " + fnum);
            }
            this.scan.close();
            this.scan = this.logFactory.getLogFileAtPosition(instant_long);
            this.currentLogFileNumber = fnum;
            if (this.scanDirection == 1) {
                this.currentLogFileLength = this.scan.length();
            }
        } else {
            long fpos = ((LogCounter)instant).getLogFilePosition();
            this.scan.seek(fpos);
            this.currentLogFileLength = this.scan.length();
            if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                SanityManager.DEBUG(LogToFile.DBG_FLAG, "Scan reset to " + String.valueOf(instant));
            }
        }
        this.knownGoodLogEnd = this.currentInstant = instant_long;
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Scan.getInstant reset to " + this.currentInstant + LogCounter.toDebugString(this.currentInstant));
        }
    }

    @Override
    public long getInstant() {
        return this.currentInstant;
    }

    @Override
    public long getLogRecordEnd() {
        return this.knownGoodLogEnd;
    }

    @Override
    public boolean isLogEndFuzzy() {
        return this.fuzzyLogEnd;
    }

    @Override
    public LogInstant getLogInstant() {
        if (this.currentInstant == 0L) {
            return null;
        }
        return new LogCounter(this.currentInstant);
    }

    @Override
    public void close() {
        if (this.scan != null) {
            try {
                this.scan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scan = null;
        }
        this.logFactory = null;
        this.currentLogFileNumber = -1L;
        this.currentLogFileLength = -1L;
        this.currentInstant = 0L;
        this.stopAt = 0L;
        this.scanDirection = 0;
    }
}

