/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.am.ClientJDBCObjectFactory;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.client.net.ClientJDBCObjectFactoryImpl;
import org.apache.derby.client.net.NetConnection;

public class ClientAutoloadedDriver
implements Driver {
    private transient int traceFileSuffixIndex_ = 0;
    private static final int DERBY_REMOTE_PROTOCOL = 1;
    private static ClientJDBCObjectFactory factoryObject = null;
    private static SQLException exceptionsOnLoadDriver__ = null;
    private static ClientAutoloadedDriver registeredDriver__ = null;

    protected static void registerMe(ClientAutoloadedDriver me) {
        SqlException ole = Configuration.getExceptionOnLoadResources();
        if (ole != null) {
            SQLException e = ole.getSQLException();
            exceptionsOnLoadDriver__ = Utils.accumulateSQLException(e, exceptionsOnLoadDriver__);
        }
        try {
            registeredDriver__ = me;
            DriverManager.registerDriver(registeredDriver__);
        }
        catch (SQLException e) {
            exceptionsOnLoadDriver__ = new SqlException(null, new ClientMessageId("XBM0N.D"), new Object[0]).getSQLException();
            exceptionsOnLoadDriver__.setNextException(e);
        }
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        NetConnection conn;
        this.checkURLNotNull(url);
        try {
            int traceLevel;
            StringTokenizer urlTokenizer;
            int protocol;
            if (exceptionsOnLoadDriver__ != null) {
                throw exceptionsOnLoadDriver__;
            }
            if (properties == null) {
                properties = new Properties();
            }
            if ((protocol = ClientAutoloadedDriver.tokenizeProtocol(url, urlTokenizer = new StringTokenizer(url, "/:= \t\n\r\f", true))) == 0) {
                return null;
            }
            String slashOrNull = null;
            if (protocol == 1) {
                try {
                    slashOrNull = urlTokenizer.nextToken(":/");
                }
                catch (NoSuchElementException e) {
                    throw new SqlException(null, new ClientMessageId("XJ028.C"), e, url);
                }
            }
            String server = ClientAutoloadedDriver.tokenizeServerName(urlTokenizer, url);
            int port = ClientAutoloadedDriver.tokenizeOptionalPortNumber(urlTokenizer, url);
            if (port == 0) {
                port = 1527;
            }
            String database = ClientAutoloadedDriver.tokenizeDatabase(urlTokenizer, url);
            Properties augmentedProperties = ClientAutoloadedDriver.tokenizeURLProperties(url, properties);
            database = this.appendDatabaseAttributes(database, augmentedProperties);
            try {
                traceLevel = BasicClientDataSource.getTraceLevel(augmentedProperties);
            }
            catch (NumberFormatException e) {
                throw new SqlException(null, new ClientMessageId("XJ213.C"), e, new Object[0]);
            }
            LogWriter dncLogWriter = BasicClientDataSource.computeDncLogWriterForNewConnection(DriverManager.getLogWriter(), BasicClientDataSource.getTraceDirectory(augmentedProperties), BasicClientDataSource.getTraceFile(augmentedProperties), BasicClientDataSource.getTraceFileAppend(augmentedProperties), traceLevel, "_driver", this.traceFileSuffixIndex_++);
            conn = (NetConnection)ClientAutoloadedDriver.getFactory().newNetConnection(dncLogWriter, DriverManager.getLoginTimeout(), server, port, database, augmentedProperties);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (conn.isConnectionNull()) {
            return null;
        }
        return conn;
    }

    private String appendDatabaseAttributes(String database, Properties augmentedProperties) {
        StringBuffer longDatabase = new StringBuffer(database);
        Enumeration<?> keys = augmentedProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("user") || key.equals("password") || key.equals("ssl")) continue;
            longDatabase.append(";" + key + "=" + augmentedProperties.getProperty(key));
        }
        return longDatabase.toString();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        this.checkURLNotNull(url);
        try {
            StringTokenizer urlTokenizer = new StringTokenizer(url, "/:=; \t\n\r\f", true);
            int protocol = ClientAutoloadedDriver.tokenizeProtocol(url, urlTokenizer);
            return protocol != 0;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void checkURLNotNull(String url) throws SQLException {
        if (url == null) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), "null").getSQLException();
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfo = new DriverPropertyInfo[2];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfo[0] = new DriverPropertyInfo("user", properties.getProperty("user", "APP"));
        driverPropertyInfo[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfo[0].description = SqlException.getMessageUtil().getTextMessage("J132", new Object[0]);
        driverPropertyInfo[1].description = SqlException.getMessageUtil().getTextMessage("J133", new Object[0]);
        driverPropertyInfo[0].required = true;
        driverPropertyInfo[1].required = false;
        return driverPropertyInfo;
    }

    @Override
    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        ClientAutoloadedDriver.getFactory();
        throw (SQLFeatureNotSupportedException)new SqlException(null, new ClientMessageId("0A000.S"), "getParentLogger").getSQLException();
    }

    private static int tokenizeProtocol(String url, StringTokenizer urlTokenizer) throws SqlException {
        if (url == null) {
            return 0;
        }
        if (urlTokenizer == null) {
            return 0;
        }
        try {
            String jdbc = urlTokenizer.nextToken(":");
            if (!jdbc.equals("jdbc")) {
                return 0;
            }
            if (!urlTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            String dbname = urlTokenizer.nextToken(":");
            int protocol = 0;
            if (!dbname.equals("derby") || url.indexOf("derby://") == -1) {
                return 0;
            }
            protocol = 1;
            if (!urlTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            return protocol;
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    private static String tokenizeServerName(StringTokenizer urlTokenizer, String url) throws SqlException {
        try {
            if (!urlTokenizer.nextToken("/").equals("/")) {
                throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
            }
            return urlTokenizer.nextToken("/:");
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
        }
    }

    private static int tokenizeOptionalPortNumber(StringTokenizer urlTokenizer, String url) throws SqlException {
        try {
            String firstToken = urlTokenizer.nextToken(":/");
            if (firstToken.equals(":")) {
                String port = urlTokenizer.nextToken("/");
                if (!urlTokenizer.nextToken("/").equals("/")) {
                    throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
                }
                return Integer.parseInt(port);
            }
            if (firstToken.equals("/")) {
                return 0;
            }
            throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), e, url);
        }
    }

    private static String tokenizeDatabase(StringTokenizer urlTokenizer, String url) throws SqlException {
        try {
            String databaseName = urlTokenizer.nextToken("\t\n\r\f;");
            return databaseName;
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), e, url);
        }
    }

    private static Properties tokenizeURLProperties(String url, Properties properties) throws SqlException {
        String attributeString = null;
        int attributeIndex = -1;
        if (url != null && (attributeIndex = url.indexOf(";")) != -1) {
            attributeString = url.substring(attributeIndex);
        }
        return BasicClientDataSource.tokenizeAttributes(attributeString, properties);
    }

    public static ClientJDBCObjectFactory getFactory() {
        if (factoryObject != null) {
            return factoryObject;
        }
        factoryObject = Configuration.supportsJDBC42() ? ClientAutoloadedDriver.createJDBC42FactoryImpl() : ClientAutoloadedDriver.createDefaultFactoryImpl();
        return factoryObject;
    }

    private static ClientJDBCObjectFactory createDefaultFactoryImpl() {
        return new ClientJDBCObjectFactoryImpl();
    }

    private static ClientJDBCObjectFactory createJDBC40FactoryImpl() {
        String factoryName = "org.apache.derby.client.net.ClientJDBCObjectFactoryImpl40";
        try {
            Class<?> clazz = Class.forName("org.apache.derby.client.net.ClientJDBCObjectFactoryImpl40");
            return (ClientJDBCObjectFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            return ClientAutoloadedDriver.createDefaultFactoryImpl();
        }
        catch (InstantiationException ie) {
            return ClientAutoloadedDriver.createDefaultFactoryImpl();
        }
        catch (IllegalAccessException iae) {
            return ClientAutoloadedDriver.createDefaultFactoryImpl();
        }
        catch (NoSuchMethodException iae) {
            return ClientAutoloadedDriver.createDefaultFactoryImpl();
        }
        catch (InvocationTargetException iae) {
            return ClientAutoloadedDriver.createDefaultFactoryImpl();
        }
    }

    private static ClientJDBCObjectFactory createJDBC42FactoryImpl() {
        String factoryName = "org.apache.derby.client.net.ClientJDBCObjectFactoryImpl42";
        try {
            Class<?> clazz = Class.forName("org.apache.derby.client.net.ClientJDBCObjectFactoryImpl42");
            return (ClientJDBCObjectFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            return ClientAutoloadedDriver.createJDBC40FactoryImpl();
        }
        catch (InstantiationException ie) {
            return ClientAutoloadedDriver.createJDBC40FactoryImpl();
        }
        catch (IllegalAccessException iae) {
            return ClientAutoloadedDriver.createJDBC40FactoryImpl();
        }
        catch (NoSuchMethodException iae) {
            return ClientAutoloadedDriver.createJDBC40FactoryImpl();
        }
        catch (InvocationTargetException iae) {
            return ClientAutoloadedDriver.createJDBC40FactoryImpl();
        }
    }

    static {
        ClientAutoloadedDriver.registerMe(new ClientAutoloadedDriver());
    }
}

