package org.apache.torque.generated.peer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.OptimisticLockingFailedException;
import org.apache.torque.TorqueException;
import org.apache.torque.test.dbobject.OptimisticLockingSimple;
import org.apache.torque.test.peer.OptimisticLockingSimplePeerImpl;

/**
 * Tests whether optimistic locking with select for update works.
 *
 * @version $Id: OptimisticLockingSimpleSelectTest.java 1448816 2013-02-21 21:45:10Z tfischer $
 */
public class OptimisticLockingSimpleSelectTest extends BaseOptimisticLockingTest<OptimisticLockingSimple>
{
    public OptimisticLockingSimpleSelectTest()
    {
        super(new OptimisticLockingSimplePeerImpl());
    }

    public OptimisticLockingSimple newObject()
    {
        return new OptimisticLockingSimple();
    }

    @Override
    public void assertOptimisticLockingDeleteException(TorqueException e) {
        assertTrue(e instanceof OptimisticLockingFailedException);
        assertEquals(
                "The row to update was either updated or deleted concurrently "
                        + "or does not exist at all.",
                e.getMessage());
    }

    @Override
    public void assertOptimisticLockingUpdateException(TorqueException e) {
        assertTrue(e instanceof OptimisticLockingFailedException);
        assertEquals(
                "The row to update was either updated or deleted concurrently "
                        + "or does not exist at all.",
                e.getMessage());
    }
}
