package org.apache.torque.generated.peer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.math.BigDecimal;
import java.util.List;

import org.apache.torque.BaseDatabaseTestCase;
import org.apache.torque.NoRowsException;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.test.dbobject.Author;
import org.apache.torque.test.peer.AuthorPeer;

/**
 * Tests the retrieveByPk methods.
 *
 * @version $Id: RetrieveByPkTest.java 1448402 2013-02-20 20:54:29Z tfischer $
 */
public class RetrieveByPkTest extends BaseDatabaseTestCase
{
    private List<Author> authorList;

    @Override
    public void setUp() throws Exception
    {
        super.setUp();
        cleanBookstore();
        authorList = insertBookstoreData();
    }

    /**
     * Tests retrieveByPk using a simple primary key
     *
     * @throws Exception if the test fails
     */
    public void testRetrieveByPk() throws Exception
    {
        ObjectKey primaryKey = authorList.get(1).getPrimaryKey();
        Author author = AuthorPeer.retrieveByPK(primaryKey);
        assertEquals("Expected author with Id "
                + authorList.get(1).getAuthorId()
                + " at first position but got "
                + author.getAuthorId(),
                authorList.get(1).getAuthorId(),
                author.getAuthorId());
    }

    /**
     * Tests retrieveByPk using a non-existent primary key
     *
     * @throws Exception if the test fails
     */
    public void testRetrieveByNonExistingPk() throws Exception
    {
        ObjectKey primaryKey = new NumberKey(-1);
        try
        {
            AuthorPeer.retrieveByPK(primaryKey);
        }
        catch (NoRowsException e)
        {
            assertEquals("Failed to select a row.", e.getMessage());
        }
    }

    /**
     * Tests retrieveByPk using a key object with a value of null.
     *
     * @throws Exception if the test fails
     */
    public void testRetrieveByNullValuePk() throws Exception
    {
        ObjectKey primaryKey = new NumberKey((BigDecimal) null);
        try
        {
            AuthorPeer.retrieveByPK(primaryKey);
        }
        catch (NoRowsException e)
        {
            assertEquals("Failed to select a row.", e.getMessage());
        }
    }

    /**
     * Tests retrieveByPk using a null key.
     *
     * @throws Exception if the test fails
     */
    public void testRetrieveByNullPk() throws Exception
    {
        try
        {
            AuthorPeer.retrieveByPK(null);
        }
        catch (NoRowsException e)
        {
            assertEquals("Failed to select a row.", e.getMessage());
        }
    }
    // TODO test retrieveByPks
}
