/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.parsers.DitContentRuleDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;

public final class DitContentRuleDescriptionSyntaxChecker
extends SyntaxChecker {
    private transient DitContentRuleDescriptionSchemaParser schemaParser = new DitContentRuleDescriptionSchemaParser();
    public static final DitContentRuleDescriptionSyntaxChecker INSTANCE = new DitContentRuleDescriptionSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.16");

    private DitContentRuleDescriptionSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        try {
            this.schemaParser.parseDITContentRuleDescription(strValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DitContentRuleDescriptionSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.16");
        }

        @Override
        public DitContentRuleDescriptionSyntaxChecker build() {
            return new DitContentRuleDescriptionSyntaxChecker(this.oid);
        }
    }
}

