/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.serialize;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Optional;

public class JdkSerializer
implements ObjectSerializer {
    private final ConversionService<?> conversionService;

    public JdkSerializer(ConversionService<?> conversionService) {
        this.conversionService = conversionService;
    }

    public JdkSerializer() {
        this(ConversionService.SHARED);
    }

    @Override
    public void serialize(Object object, OutputStream outputStream) throws SerializationException {
        try (ObjectOutputStream objectOut = this.createObjectOutput(outputStream);){
            objectOut.writeObject(object);
            objectOut.flush();
        }
        catch (IOException e) {
            throw new SerializationException("I/O error occurred during serialization: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<T> deserialize(InputStream inputStream, Class<T> requiredType) throws SerializationException {
        try {
            ObjectInputStream objectIn = this.createObjectInput(inputStream, requiredType);
            try {
                Object readObject = objectIn.readObject();
                Optional<T> optional = this.conversionService.convert(readObject, requiredType);
                return optional;
            }
            catch (ClassCastException cce) {
                throw new SerializationException("Invalid type deserialized from stream: " + cce.getMessage(), cce);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException("Type not found deserializing from stream: " + e.getMessage(), e);
            }
            finally {
                if (objectIn != null) {
                    try {
                        objectIn.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException("I/O error occurred during deserialization: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<T> deserialize(InputStream inputStream, Argument<T> requiredType) throws SerializationException {
        try {
            ObjectInputStream objectIn = this.createObjectInput(inputStream, requiredType.getType());
            try {
                Object readObject = objectIn.readObject();
                Optional<T> optional = this.conversionService.convert(readObject, requiredType);
                return optional;
            }
            catch (ClassCastException cce) {
                throw new SerializationException("Invalid type deserialized from stream: " + cce.getMessage(), cce);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException("Type not found deserializing from stream: " + e.getMessage(), e);
            }
            finally {
                if (objectIn != null) {
                    try {
                        objectIn.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException("I/O error occurred during deserialization: " + e.getMessage(), e);
        }
    }

    protected ObjectOutputStream createObjectOutput(OutputStream outputStream) throws IOException {
        return new ObjectOutputStream(outputStream);
    }

    protected ObjectInputStream createObjectInput(InputStream inputStream, final Class<?> requiredType) throws IOException {
        return new ObjectInputStream(inputStream){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                Optional<Class> aClass = ClassUtils.forName(desc.getName(), requiredType.getClassLoader());
                if (aClass.isPresent()) {
                    return aClass.get();
                }
                return super.resolveClass(desc);
            }
        };
    }
}

