/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport;

import com.google.common.base.Preconditions;
import jakarta.mail.MessagingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.transport.SMIMESignerInfo;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.SMIMESigned;

public class KeyStoreHolder {
    private static final String BC = "BC";
    protected KeyStore keyStore;

    public KeyStoreHolder(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public List<SMIMESignerInfo> verifySignatures(SMIMESigned signed) throws Exception {
        CertStore certs = new JcaCertStoreBuilder().addCertificates(signed.getCertificates()).addCRLs(signed.getCRLs()).build();
        SignerInformationStore siginfo = signed.getSignerInfos();
        Collection sigCol = siginfo.getSigners();
        ArrayList<SMIMESignerInfo> result = new ArrayList<SMIMESignerInfo>(sigCol.size());
        for (SignerInformation info : sigCol) {
            X509CertificateHolderSelector x509CertificateHolderSelector = new X509CertificateHolderSelector(info.getSID().getSubjectKeyIdentifier());
            X509CertSelector certSelector = new JcaX509CertSelectorConverter().getCertSelector(x509CertificateHolderSelector);
            Collection<? extends Certificate> certCollection = certs.getCertificates(certSelector);
            for (X509Certificate x509Certificate : certCollection) {
                CertPath path = KeyStoreHolder.verifyCertificate(x509Certificate, certs, this.keyStore);
                try {
                    if (!info.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(x509Certificate))) continue;
                    result.add(new SMIMESignerInfo(x509Certificate, path, true));
                }
                catch (Exception e) {
                    result.add(new SMIMESignerInfo(x509Certificate, path, false));
                }
            }
        }
        return result;
    }

    private static CertPath verifyCertificate(X509Certificate cert, CertStore store, KeyStore trustedStore) throws InvalidAlgorithmParameterException, KeyStoreException, MessagingException, CertPathBuilderException {
        CertPathBuilder pathBuilder;
        Preconditions.checkNotNull((Object)cert);
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)trustedStore);
        try {
            pathBuilder = CertPathBuilder.getInstance("PKIX", BC);
        }
        catch (Exception e) {
            throw new MessagingException("Error during the creation of the certpathbuilder.", e);
        }
        X509CertSelector xcs = new X509CertSelector();
        xcs.setCertificate(cert);
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustedStore, (CertSelector)xcs);
        params.addCertStore(store);
        params.setRevocationEnabled(false);
        try {
            CertPathBuilderResult result = pathBuilder.build(params);
            return result.getCertPath();
        }
        catch (CertPathBuilderException e) {
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MessagingException("Error during the certification path search.", (Exception)e);
        }
    }
}

