/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.region.persist.internal;

import org.apache.karaf.region.persist.RegionsPersistence;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionsBundleTracker {
    private static final Logger log = LoggerFactory.getLogger(RegionsBundleTracker.class);
    private BundleTracker bundleTracker;
    private RegionsPersistence regionsPersistence;

    void start(BundleContext bundleContext, RegionsPersistence regionsPersistence) {
        this.regionsPersistence = regionsPersistence;
        int stateMask = 2;
        this.bundleTracker = new BundleTracker(bundleContext, stateMask, new BundleTrackerCustomizer(){

            public Object addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                return RegionsBundleTracker.this.addingBundle(bundle);
            }

            public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object o) {
            }

            public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Object o) {
            }
        });
        this.bundleTracker.open();
    }

    private Object addingBundle(Bundle bundle) {
        String region = (String)bundle.getHeaders().get("Region");
        if (region != null) {
            try {
                this.regionsPersistence.install(bundle, region);
                this.regionsPersistence.save();
                log.debug("Installed bundle " + bundle + " in region " + region);
                return bundle;
            }
            catch (Exception e) {
                log.info("Could not install bundle " + bundle + " in region " + region, (Throwable)e);
            }
        }
        return null;
    }

    void stop() {
        this.bundleTracker.close();
    }
}

