/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.region.persist.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.karaf.region.persist.RegionsPersistence;
import org.apache.karaf.region.persist.internal.model.FilterAttributeType;
import org.apache.karaf.region.persist.internal.model.FilterBundleType;
import org.apache.karaf.region.persist.internal.model.FilterNamespaceType;
import org.apache.karaf.region.persist.internal.model.FilterPackageType;
import org.apache.karaf.region.persist.internal.model.FilterType;
import org.apache.karaf.region.persist.internal.model.RegionBundleType;
import org.apache.karaf.region.persist.internal.model.RegionType;
import org.apache.karaf.region.persist.internal.model.RegionsType;
import org.apache.karaf.region.persist.internal.util.ManifestHeaderProcessor;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionsPersistenceImpl
implements RegionsPersistence {
    private static final Logger log = LoggerFactory.getLogger(RegionsPersistenceImpl.class);
    private JAXBContext jaxbContext;
    private RegionDigraph regionDigraph;
    private Region kernel;
    private Bundle digraphBundle;
    private Bundle framework;

    public RegionsPersistenceImpl(RegionDigraph regionDigraph, Bundle digraphBundle, Bundle framework) throws JAXBException, BundleException, IOException, InvalidSyntaxException {
        log.info("Loading region digraph persistence");
        this.digraphBundle = digraphBundle;
        this.framework = framework;
        this.regionDigraph = regionDigraph;
        this.kernel = regionDigraph.getRegion(0L);
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RegionsType.class});
        this.load();
    }

    @Override
    public void install(Bundle b, String regionName) throws BundleException {
        Region region = this.regionDigraph.getRegion(regionName);
        if (region == null) {
            region = this.regionDigraph.createRegion(regionName);
        }
        this.kernel.removeBundle(b);
        region.addBundle(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws BundleException, IOException {
        File digraphFile = this.digraphBundle.getBundleContext().getDataFile("digraph");
        FileOutputStream digraphStream = new FileOutputStream(digraphFile);
        try {
            this.regionDigraph.getRegionDigraphPersistence().save(this.regionDigraph, (OutputStream)digraphStream);
        }
        finally {
            digraphStream.close();
        }
    }

    void save(RegionsType regionsType, Writer out) throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.marshal((Object)regionsType, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws IOException, BundleException, JAXBException, InvalidSyntaxException {
        if (this.regionDigraph.getRegions().size() <= 1) {
            File etc = new File(System.getProperty("karaf.etc"));
            File regionsConfig = new File(etc, "regions-config.xml");
            if (regionsConfig.exists()) {
                log.info("initializing region digraph from etc/regions-config.xml");
                FileReader in = new FileReader(regionsConfig);
                try {
                    this.load(this.regionDigraph, in);
                }
                finally {
                    ((Reader)in).close();
                }
            } else {
                log.info("no regions config file");
            }
        }
    }

    void load(RegionDigraph regionDigraph, Reader in) throws JAXBException, BundleException, InvalidSyntaxException {
        RegionsType regionsType = this.load(in);
        this.load(regionsType, regionDigraph);
    }

    RegionsType load(Reader in) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        return (RegionsType)unmarshaller.unmarshal(in);
    }

    void load(RegionsType regionsType, RegionDigraph regionDigraph) throws BundleException, InvalidSyntaxException {
        BundleContext frameworkContext = this.framework.getBundleContext();
        for (RegionType regionType : regionsType.getRegion()) {
            String name = regionType.getName();
            log.debug("Creating region: " + name);
            Region region = regionDigraph.createRegion(name);
            for (RegionBundleType bundleType : regionType.getBundle()) {
                if (bundleType.getId() != null) {
                    region.addBundle(bundleType.getId().longValue());
                    continue;
                }
                Bundle b = frameworkContext.getBundle(bundleType.getLocation());
                region.addBundle(b);
            }
        }
        for (FilterType filterType : regionsType.getFilter()) {
            String filter;
            List<FilterAttributeType> attributeTypes;
            String namespace;
            String version;
            Region from = regionDigraph.getRegion(filterType.getFrom());
            Region to = regionDigraph.getRegion(filterType.getTo());
            log.debug("Creating filter between " + from.getName() + " to " + to.getName());
            RegionFilterBuilder builder = regionDigraph.createRegionFilterBuilder();
            for (FilterBundleType bundleType : filterType.getBundle()) {
                String symbolicName = bundleType.getSymbolicName();
                version = bundleType.getVersion();
                if (bundleType.getId() != null) {
                    Bundle b = frameworkContext.getBundle(bundleType.getId().longValue());
                    symbolicName = b.getSymbolicName();
                    version = b.getVersion().toString();
                }
                namespace = "osgi.wiring.bundle";
                attributeTypes = bundleType.getAttribute();
                this.buildFilter(symbolicName, version, namespace, attributeTypes, builder);
            }
            for (FilterPackageType packageType : filterType.getPackage()) {
                String packageName = packageType.getName();
                version = packageType.getVersion();
                namespace = "osgi.wiring.package";
                attributeTypes = packageType.getAttribute();
                this.buildFilter(packageName, version, namespace, attributeTypes, builder);
            }
            if (to == this.kernel) {
                BundleRevision rev = (BundleRevision)this.framework.adapt(BundleRevision.class);
                List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
                for (BundleCapability cap : caps) {
                    filter = ManifestHeaderProcessor.generateFilter(this.filter(cap.getAttributes()));
                    builder.allow("osgi.wiring.package", filter);
                }
            }
            for (FilterNamespaceType namespaceType : filterType.getNamespace()) {
                String namespace2 = namespaceType.getName();
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                for (FilterAttributeType attributeType : namespaceType.getAttribute()) {
                    attributes.put(attributeType.getName(), attributeType.getValue());
                }
                filter = ManifestHeaderProcessor.generateFilter(attributes);
                builder.allow(namespace2, filter);
            }
            regionDigraph.connect(from, builder.build(), to);
        }
    }

    private Map<String, Object> filter(Map<String, Object> attributes) {
        HashMap<String, Object> result = new HashMap<String, Object>(attributes);
        result.remove("bundle-version");
        result.remove("bundle-symbolic-name");
        return result;
    }

    private void buildFilter(String packageName, String version, String namespace, List<FilterAttributeType> attributeTypes, RegionFilterBuilder builder) throws InvalidSyntaxException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (namespace != null) {
            attributes.put(namespace, packageName);
        }
        if (version != null) {
            attributes.put("version", version);
        }
        for (FilterAttributeType attributeType : attributeTypes) {
            attributes.put(attributeType.getName(), attributeType.getValue());
        }
        String filter = ManifestHeaderProcessor.generateFilter(attributes);
        builder.allow(namespace, filter);
    }
}

