/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.faces.view.facelets.FaceletsResourceResolver;
import org.apache.myfaces.config.element.NamedEvent;

public class CdiAnnotationProviderExtension
implements Extension {
    private Map<Class<? extends Annotation>, Set<Class<?>>> map;
    private Class<? extends Annotation>[] annotationsToScan = new Class[]{FacesComponent.class, FacesBehavior.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, NamedEvent.class, FacesBehaviorRenderer.class, FaceletsResourceResolver.class};

    public CdiAnnotationProviderExtension() {
        this.map = new HashMap(this.annotationsToScan.length, 1.0f);
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        for (Class<? extends Annotation> annotation : this.annotationsToScan) {
            if (!type.isAnnotationPresent(annotation)) continue;
            Set set = this.map.computeIfAbsent(annotation, k -> new HashSet());
            set.add(type.getJavaClass());
        }
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getMap() {
        return this.map;
    }

    public void release() {
        if (this.map != null) {
            this.map.clear();
            this.map = null;
        }
        this.annotationsToScan = null;
    }
}

