/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider;
import org.apache.myfaces.shared.util.ClassUtils;

public class ResourceAnnotationLifecycleProvider
extends NoInjectionAnnotationLifecycleProvider {
    private static volatile WeakHashMap<ClassLoader, Map<Class, Field[]>> declaredFieldBeans = new WeakHashMap();
    protected Context context;
    private static final String JAVA_COMP_ENV = "java:comp/env/";

    public ResourceAnnotationLifecycleProvider(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, Field[]> getDeclaredFieldBeansMap() {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        Map<Class, Field[]> metadata = declaredFieldBeans.get(cl);
        if (metadata == null) {
            WeakHashMap<ClassLoader, Map<Class, Field[]>> weakHashMap = declaredFieldBeans;
            synchronized (weakHashMap) {
                metadata = ResourceAnnotationLifecycleProvider.createDeclaredFieldBeansMap(cl, metadata);
            }
        }
        return metadata;
    }

    private static Map<Class, Field[]> createDeclaredFieldBeansMap(ClassLoader cl, Map<Class, Field[]> metadata) {
        metadata = declaredFieldBeans.get(cl);
        if (metadata == null) {
            metadata = new HashMap<Class, Field[]>();
            declaredFieldBeans.put(cl, metadata);
        }
        return metadata;
    }

    @Override
    protected void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        this.checkAnnotation(instance.getClass(), instance);
        for (Class<?> superclass = instance.getClass().getSuperclass(); superclass != null && !superclass.equals(Object.class); superclass = superclass.getSuperclass()) {
            this.checkAnnotation(superclass, instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Field[] getDeclaredFieldBeans(Class clazz) {
        Map<Class, Field[]> declaredFieldBeansMap = ResourceAnnotationLifecycleProvider.getDeclaredFieldBeansMap();
        Field[] fields = declaredFieldBeansMap.get(clazz);
        if (fields == null) {
            fields = clazz.getDeclaredFields();
            Map<Class, Field[]> map = declaredFieldBeansMap;
            synchronized (map) {
                declaredFieldBeansMap.put(clazz, fields);
            }
        }
        return fields;
    }

    private void checkAnnotation(Class<?> clazz, Object instance) throws NamingException, IllegalAccessException, InvocationTargetException {
        Field[] fields = this.getDeclaredFieldBeans(clazz);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            this.checkFieldAnnotation(field, instance);
        }
        Method[] methods = this.getDeclaredMethods(clazz);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.checkMethodAnnotation(method, instance);
        }
    }

    protected void checkMethodAnnotation(Method method, Object instance) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (method.isAnnotationPresent(Resource.class)) {
            Resource annotation = method.getAnnotation(Resource.class);
            ResourceAnnotationLifecycleProvider.lookupMethodResource(this.context, instance, method, annotation.name());
        }
    }

    protected void checkFieldAnnotation(Field field, Object instance) throws NamingException, IllegalAccessException {
        if (field.isAnnotationPresent(Resource.class)) {
            Resource annotation = field.getAnnotation(Resource.class);
            ResourceAnnotationLifecycleProvider.lookupFieldResource(this.context, instance, field, annotation.name());
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name) throws NamingException, IllegalAccessException {
        Object lookedupResource = name != null && name.length() > 0 ? context.lookup(JAVA_COMP_ENV + name) : context.lookup(JAVA_COMP_ENV + instance.getClass().getName() + "/" + field.getName());
        boolean accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = name != null && name.length() > 0 ? context.lookup(JAVA_COMP_ENV + name) : context.lookup(JAVA_COMP_ENV + instance.getClass().getName() + "/" + ResourceAnnotationLifecycleProvider.getFieldName(method));
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }

    protected static String getFieldName(Method setter) {
        StringBuilder name = new StringBuilder(setter.getName());
        name.delete(0, 3);
        name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        return name.toString();
    }
}

