/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.AbstractFaceletCache;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.impl.DefaultFacelet;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

class CacheELFaceletCacheImpl
extends AbstractFaceletCache<DefaultFacelet> {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    private Map<String, FaceletNode> _facelets;
    private Map<String, DefaultFacelet> _viewMetadataFacelets;
    private Map<String, DefaultFacelet> _compositeComponentMetadataFacelets;
    private long _refreshPeriod;

    CacheELFaceletCacheImpl(long refreshPeriod) {
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        this._facelets = new ConcurrentHashMap<String, FaceletNode>();
        this._viewMetadataFacelets = new ConcurrentHashMap<String, DefaultFacelet>();
        this._compositeComponentMetadataFacelets = new ConcurrentHashMap<String, DefaultFacelet>();
    }

    public DefaultFacelet getFacelet(URL url) throws IOException {
        DefaultFacelet f;
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        FaceletNode node = this._facelets.get(key);
        DefaultFacelet defaultFacelet = f = node != null ? node.getFacelet() : null;
        if (f == null || this.needsToBeRefreshed(f)) {
            Set<String> paramsSet = null;
            if (node != null) {
                paramsSet = node.getParams();
            }
            f = (DefaultFacelet)((Object)this.getMemberFactory().newInstance(url));
            if (this._refreshPeriod != 0L) {
                this._facelets.put(key, paramsSet != null && !paramsSet.isEmpty() ? new FaceletNode(f, paramsSet) : new FaceletNode(f));
            }
        }
        return f;
    }

    @Override
    public DefaultFacelet getFacelet(FaceletContext ctx, URL url) throws IOException {
        String key = url.toString();
        FaceletNode node = this._facelets.get(key);
        DefaultFacelet f = node != null ? node.getFacelet() : null;
        Set<String> paramsSet = Collections.emptySet();
        paramsSet = node != null ? node.getParams() : paramsSet;
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        Set<String> knownParameters = actx.getTemplateContext().isKnownParametersEmpty() ? Collections.emptySet() : actx.getTemplateContext().getKnownParameters();
        boolean create = false;
        for (String paramKey : knownParameters) {
            if (paramsSet.contains(paramKey)) continue;
            create = true;
            break;
        }
        if (f == null || this.needsToBeRefreshed(f) || create) {
            f = (DefaultFacelet)((Object)this.getMemberFactory().newInstance(url));
            if (this._refreshPeriod != 0L) {
                if (!paramsSet.isEmpty() || !knownParameters.isEmpty()) {
                    paramsSet = new HashSet(paramsSet);
                    paramsSet.addAll(knownParameters);
                    this._facelets.put(key, new FaceletNode(f, paramsSet));
                } else {
                    this._facelets.put(key, new FaceletNode(f));
                }
            }
        }
        if (!paramsSet.isEmpty()) {
            for (String param : paramsSet) {
                if (actx.getTemplateContext().containsKnownParameter(param)) continue;
                actx.getTemplateContext().addKnownParameters(param);
            }
        }
        return f;
    }

    public boolean isFaceletCached(URL url) {
        return this._facelets.containsKey(url.toString());
    }

    public DefaultFacelet getViewMetadataFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._viewMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)((Object)this.getMetadataMemberFactory().newInstance(url));
            if (this._refreshPeriod != 0L) {
                this._viewMetadataFacelets.put(key, f);
            }
        }
        return f;
    }

    public boolean isViewMetadataFaceletCached(URL url) {
        return this._viewMetadataFacelets.containsKey(url.toString());
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                long lastModified = ResourceLoaderUtils.getResourceLastModified(facelet.getSource());
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public DefaultFacelet getCompositeComponentMetadataFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._compositeComponentMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)((Object)this.getCompositeComponentMetadataMemberFactory().newInstance(url));
            if (this._refreshPeriod != 0L) {
                this._compositeComponentMetadataFacelets.put(key, f);
            }
        }
        return f;
    }

    @Override
    public boolean isCompositeComponentMetadataFaceletCached(URL url) {
        return this._compositeComponentMetadataFacelets.containsKey(url.toString());
    }

    private static class FaceletNode {
        private DefaultFacelet facelet;
        private Set<String> params;

        public FaceletNode(DefaultFacelet facelet) {
            this.facelet = facelet;
            this.params = Collections.emptySet();
        }

        public FaceletNode(DefaultFacelet facelet, Set<String> params) {
            this.facelet = facelet;
            this.params = params;
        }

        public DefaultFacelet getFacelet() {
            return this.facelet;
        }

        public void setFacelet(DefaultFacelet facelet) {
            this.facelet = facelet;
        }

        public Set<String> getParams() {
            return this.params;
        }

        public void setParams(Set<String> params) {
            this.params = params;
        }
    }
}

