/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.logging.tomcat;

import java.io.File;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class LoggingPropertiesServerListener
implements LifecycleListener {
    public static final String CATALINA_BASE_PROPERTY_NAME = "catalina.base";
    public static final String CATALINA_HOME_PROPERTY_NAME = "catalina.home";
    public static final String CATALINA_LOGS_DIRECTORY_NAME = "logs";
    public static final String LOG_DIR_PROPERTY_NAME = "org.apache.portals.logdir";
    private String logDir;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            String logDirOverride = System.getProperty(LOG_DIR_PROPERTY_NAME);
            if (logDirOverride == null) {
                if (this.logDir == null) {
                    File catalinaLogsDirectoryFile;
                    String catalinaBase = System.getProperty(CATALINA_BASE_PROPERTY_NAME);
                    if (catalinaBase == null) {
                        catalinaBase = System.getProperty(CATALINA_HOME_PROPERTY_NAME);
                    }
                    if (catalinaBase != null && (catalinaLogsDirectoryFile = new File(catalinaBase + File.separator + CATALINA_LOGS_DIRECTORY_NAME)).isDirectory()) {
                        this.logDir = catalinaLogsDirectoryFile.getAbsolutePath();
                    }
                }
                if (this.logDir != null) {
                    File logDirFile = new File(this.logDir);
                    if (!logDirFile.isDirectory() && !logDirFile.exists()) {
                        logDirFile.mkdirs();
                    }
                    if (logDirFile.isDirectory()) {
                        System.out.println("Setting org.apache.portals.logdir = " + this.logDir);
                        System.setProperty(LOG_DIR_PROPERTY_NAME, this.logDir);
                    } else {
                        System.err.println("Unable to set org.apache.portals.logdir: logDir attribute " + this.logDir + " does not exist and cannot be created or is not a directory.");
                    }
                } else {
                    System.err.println("Unable to set org.apache.portals.logdir: logDir attribute not set and catalina.base or catalina.home system properties not available or logs directory missing.");
                }
            } else {
                this.logDir = logDirOverride;
                System.out.println("Overridden org.apache.portals.logdir = " + this.logDir);
            }
        }
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }
}

