/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.rewriter.htmlcleaner;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagNodeVisitor;

public abstract class AbstractProxyTagNodeVisitor
implements TagNodeVisitor {
    private Map<String, String[]> tagNameAndLinkAttrs = new HashMap<String, String[]>();

    public AbstractProxyTagNodeVisitor(Map<String, String[]> tagNameAndLinkAttrs) {
        if (tagNameAndLinkAttrs != null) {
            this.tagNameAndLinkAttrs.putAll(tagNameAndLinkAttrs);
        }
    }

    public boolean visit(TagNode parentNode, HtmlNode htmlNode) {
        if (htmlNode instanceof TagNode) {
            return this.visitTagNode(parentNode, (TagNode)htmlNode);
        }
        if (htmlNode instanceof CommentNode) {
            return this.visitCommentNode(parentNode, (CommentNode)htmlNode);
        }
        return true;
    }

    protected boolean visitTagNode(TagNode parentNode, TagNode tag) {
        String tagName = tag.getName();
        Object[] linkAttrNames = this.tagNameAndLinkAttrs.get(tagName);
        if (ArrayUtils.isEmpty((Object[])linkAttrNames)) {
            return true;
        }
        for (Object linkAttrName : linkAttrNames) {
            String rewrittenLink;
            String link;
            if (!StringUtils.isNotEmpty((String)linkAttrName) || !StringUtils.isNotEmpty((String)(link = tag.getAttributeByName((String)linkAttrName))) || StringUtils.equals((String)link, (String)(rewrittenLink = this.rewriteURI(tagName, (String)linkAttrName, link)))) continue;
            tag.addAttribute((String)linkAttrName, rewrittenLink);
        }
        return true;
    }

    protected boolean visitCommentNode(TagNode parentNode, CommentNode comment) {
        return true;
    }

    protected abstract String rewriteURI(String var1, String var2, String var3);
}

