/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.rewriter.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.portals.applications.webcontent2.rewriter.Source;

public class StreamSource
implements Source {
    private InputStream input;
    private String characterEncoding;
    private Reader reader;

    public StreamSource(InputStream input) {
        this(input, null);
    }

    public StreamSource(InputStream input, String characterEncoding) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null.");
        }
        this.input = input;
        this.characterEncoding = characterEncoding;
    }

    public StreamSource(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null.");
        }
        this.reader = reader;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException("getReader() has already been called on this source.");
        }
        return this.input;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.input != null) {
            throw new IllegalStateException("getInputStream() has already been called on this source.");
        }
        if (this.reader == null) {
            this.reader = this.characterEncoding == null ? new InputStreamReader(this.input) : new InputStreamReader(this.input, this.characterEncoding);
        }
        return this.reader;
    }
}

