/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.chain.Command;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.portals.applications.webcontent2.proxy.HttpClientContextBuilder;
import org.apache.portals.applications.webcontent2.proxy.ProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.builder.ProxyProcessingChainBuilder;
import org.apache.portals.applications.webcontent2.proxy.impl.ProxyProcessingChain;

public abstract class AbstractProxyProcessingChainBuilder
implements ProxyProcessingChainBuilder {
    private ProxyProcessingChain chain;
    private List<Command> commands;

    @Override
    public ProxyProcessingChain build(ProxyMappingRegistry proxyMappingRegistry, HttpClientBuilder httpClientBuilder, HttpClientContextBuilder httpClientContextBuilder) {
        if (this.chain == null) {
            this.chain = new ProxyProcessingChain();
        }
        this.initializeCommands(proxyMappingRegistry, httpClientBuilder, httpClientContextBuilder);
        if (this.commands != null) {
            for (Command command : this.commands) {
                this.chain.addCommand(command);
            }
        }
        return this.chain;
    }

    public void addCommand(Command command) {
        if (this.commands == null) {
            this.commands = new ArrayList<Command>();
        }
        this.commands.add(command);
    }

    public void removeCommand(Command command) {
        if (this.commands != null) {
            this.commands.remove(command);
        }
    }

    public void removeAllCommands() {
        if (this.commands != null) {
            this.commands.clear();
        }
    }

    protected abstract void initializeCommands(ProxyMappingRegistry var1, HttpClientBuilder var2, HttpClientContextBuilder var3);
}

