/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.apache.portals.applications.webcontent2.proxy.util.RequestUtils;

public class AddHeadersToResponseCommand
extends AbstractProxyCommand {
    private String hostHeaderValue;

    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        HttpResponse httpResponse = context.getHttpResponse();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 300 && statusCode <= 304) {
            return false;
        }
        context.getRequestContext().setStatus(statusCode);
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            Header[] headerArrayResponse;
            for (Header header : headerArrayResponse = httpResponse.getAllHeaders()) {
                String headerName = header.getName();
                if (StringUtils.startsWithIgnoreCase((String)headerName, (String)"Set-Cookie") || (StringUtils.equalsIgnoreCase((String)headerName, (String)"Content-Length") || StringUtils.equalsIgnoreCase((String)headerName, (String)"Content-Encoding")) && (context.getContentRewriter() != null || RequestUtils.isDispatched(context.getRequestContext()))) continue;
                String headerValue = header.getValue();
                if (StringUtils.equalsIgnoreCase((String)headerName, (String)"Host")) {
                    String host = this.getHostHeaderValue();
                    if (host == null) {
                        host = context.getRequestContext().getServerPort() == 80 ? context.getRequestContext().getServerName() : context.getRequestContext().getServerName() + ":" + context.getRequestContext().getServerPort();
                    }
                    context.getRequestContext().setHeader(headerName, host);
                    continue;
                }
                context.getRequestContext().setHeader(headerName, headerValue);
            }
        }
        return false;
    }

    public String getHostHeaderValue() {
        return this.hostHeaderValue;
    }

    public void setHostHeaderValue(String hostHeaderValue) {
        this.hostHeaderValue = hostHeaderValue;
    }
}

