/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupCommand
extends AbstractProxyCommand {
    private static Logger log = LoggerFactory.getLogger(CleanupCommand.class);

    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        HttpClient httpClient;
        HttpEntity httpEntity;
        HttpResponse httpResponse;
        HttpRequestBase httpRequest = context.getHttpRequest();
        if (httpRequest != null) {
            try {
                httpRequest.abort();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to abort http request.", (Throwable)e);
                }
                log.warn("Failed to abort http request. " + e);
            }
        }
        if ((httpResponse = context.getHttpResponse()) != null && (httpEntity = httpResponse.getEntity()) != null) {
            try {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to consume http entity.", (Throwable)e);
                }
                log.warn("Failed to consume http entity. " + e);
            }
        }
        if ((httpClient = context.getHttpClient()) instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)httpClient).close();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to close http client.", (Throwable)e);
                }
                log.warn("Failed to close http client. " + e);
            }
        }
        return false;
    }
}

