/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import java.net.URI;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.URICleaner;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveRemoteURICommand
extends AbstractProxyCommand {
    private static Logger log = LoggerFactory.getLogger(ResolveRemoteURICommand.class);
    private URICleaner uriCleaner;

    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        String queryString;
        String localPath = context.getLocalPath();
        String remoteURI = context.getResolvedMapping().resolveRemoteFromLocal(localPath);
        if (remoteURI == null) {
            throw new ReverseProxyException(404, "No mapped URI.");
        }
        if (remoteURI.startsWith("//")) {
            String defaultScheme = this.getDefaultScheme(context);
            remoteURI = new StringBuilder(remoteURI.length() + 6).append(defaultScheme).append(':').append(remoteURI).toString();
        }
        if ((queryString = context.getRequestContext().getQueryString()) != null) {
            remoteURI = new StringBuilder(remoteURI.length() + 1 + queryString.length()).append(remoteURI).append('?').append(queryString).toString();
        }
        if (this.uriCleaner != null) {
            remoteURI = this.uriCleaner.clean(remoteURI);
        }
        URI remoteURIObj = null;
        try {
            remoteURIObj = URI.create(remoteURI);
        }
        catch (Exception e) {
            log.error("Invalid remote target URI: '{}'.", (Object)remoteURI);
            return true;
        }
        context.setRemoteURI(remoteURIObj);
        return false;
    }

    public URICleaner getUriCleaner() {
        return this.uriCleaner;
    }

    public void setUriCleaner(URICleaner uriCleaner) {
        this.uriCleaner = uriCleaner;
    }

    protected String getDefaultScheme(ProxyContext context) {
        return context.getRequestContext().getScheme();
    }
}

