/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.ProxyMappingRegistry;

public class DefaultProxyMappingRegistry
implements ProxyMappingRegistry {
    private List<ProxyMapping> proxyMappings = new ArrayList<ProxyMapping>();

    @Override
    public boolean addProxyMapping(ProxyMapping proxyMapping) {
        return this.proxyMappings.add(proxyMapping);
    }

    @Override
    public boolean addAllProxyMappings(Collection<ProxyMapping> proxyMappingsCollection) {
        if (proxyMappingsCollection != null) {
            return this.proxyMappings.addAll(proxyMappingsCollection);
        }
        return false;
    }

    @Override
    public boolean removeProxyMapping(ProxyMapping proxyMapping) {
        return this.proxyMappings.remove(proxyMapping);
    }

    @Override
    public Collection<ProxyMapping> getProxyMappings() {
        return Collections.unmodifiableCollection(this.proxyMappings);
    }

    @Override
    public ProxyMapping findProxyMappingByLocalPath(String localPath) {
        if (localPath == null) {
            return null;
        }
        for (ProxyMapping proxyMapping : this.proxyMappings) {
            if (!proxyMapping.matchesLocal(localPath)) continue;
            return proxyMapping;
        }
        return null;
    }

    @Override
    public ProxyMapping findProxyMappingByRemoteURI(URI remoteURI) {
        if (remoteURI == null) {
            return null;
        }
        for (ProxyMapping proxyMapping : this.proxyMappings) {
            if (!proxyMapping.matchesRemote(remoteURI)) continue;
            return proxyMapping;
        }
        return null;
    }
}

