/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import org.apache.portals.applications.webcontent2.rewriter.Source;

public class GzippedSource
implements Source {
    private final Source source;
    private final String characterEncoding;

    public GzippedSource(Source source) {
        this(source, null);
    }

    public GzippedSource(Source source, String characterEncoding) {
        this.source = source;
        this.characterEncoding = characterEncoding;
    }

    public InputStream getInputStream() throws IOException {
        return new GZIPInputStream(this.source.getInputStream());
    }

    public Reader getReader() throws IOException {
        if (this.characterEncoding != null) {
            return new InputStreamReader(this.getInputStream(), this.characterEncoding);
        }
        return new InputStreamReader(this.getInputStream());
    }
}

