/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyMapping;

public class RegexProxyMapping
extends AbstractProxyMapping {
    private String localPattern;
    private String remoteReplace;
    private String remotePattern;
    private String localReplace;
    private Pattern localPatternObject;
    private Pattern remotePatternObject;

    public String getLocalPattern() {
        return this.localPattern;
    }

    public void setLocalPattern(String localPattern) {
        this.localPattern = localPattern;
        this.localPatternObject = Pattern.compile(localPattern);
    }

    public String getRemoteReplace() {
        return this.remoteReplace;
    }

    public void setRemoteReplace(String remoteReplace) {
        this.remoteReplace = remoteReplace;
    }

    public String getRemotePattern() {
        return this.remotePattern;
    }

    public void setRemotePattern(String remotePattern) {
        this.remotePattern = remotePattern;
        this.remotePatternObject = Pattern.compile(remotePattern);
    }

    public String getLocalReplace() {
        return this.localReplace;
    }

    public void setLocalReplace(String localReplace) {
        this.localReplace = localReplace;
    }

    @Override
    public boolean matchesLocal(String localPath) {
        Matcher m = this.localPatternObject.matcher(localPath);
        return m.matches();
    }

    @Override
    public String resolveRemoteFromLocal(String localPath) {
        Matcher m = this.localPatternObject.matcher(localPath);
        if (m.matches()) {
            return m.replaceFirst(this.remoteReplace);
        }
        return null;
    }

    @Override
    public boolean matchesRemote(URI remoteURI) {
        Matcher m = this.remotePatternObject.matcher(remoteURI.toString());
        return m.matches();
    }

    @Override
    public String resolveLocalFromRemote(URI remoteURI) {
        Matcher m = this.remotePatternObject.matcher(remoteURI.toString());
        if (m.matches()) {
            return m.replaceFirst(this.localReplace);
        }
        return null;
    }
}

