/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.portals.applications.webcontent2.proxy.RequestContext;
import org.apache.portals.applications.webcontent2.proxy.impl.HttpServletResponseSink;
import org.apache.portals.applications.webcontent2.proxy.util.RequestUtils;
import org.apache.portals.applications.webcontent2.rewriter.Sink;

public class ServletRequestContext
implements RequestContext {
    private String requestBasePath;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private Sink sink;

    public ServletRequestContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRequestBasePath() {
        if (this.requestBasePath != null) {
            return this.requestBasePath;
        }
        StringBuilder sb = new StringBuilder(20);
        sb.append(RequestUtils.getContextPath(this.request));
        String servletPath = RequestUtils.getServletPath(this.request);
        if (servletPath != null) {
            sb.append(servletPath);
        }
        return sb.toString();
    }

    public void setRequestBasePath(String requestBasePath) {
        this.requestBasePath = requestBasePath;
    }

    @Override
    public String getPathInfo() {
        String requestURI;
        if (this.requestBasePath != null && (requestURI = RequestUtils.getRequestURI(this.request)).startsWith(this.requestBasePath)) {
            return requestURI.substring(this.requestBasePath.length());
        }
        return RequestUtils.getPathInfo(this.request);
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    @Override
    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.response.sendRedirect(location);
    }

    @Override
    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    @Override
    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    @Override
    public Sink getSink() {
        if (this.sink == null) {
            this.sink = new HttpServletResponseSink(this.response);
        }
        return this.sink;
    }
}

