/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.rewriter;

import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.ProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.RequestContext;
import org.apache.portals.applications.webcontent2.proxy.util.CharArraySegment;
import org.apache.portals.applications.webcontent2.proxy.util.RewriterUtils;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewritingContext;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewritingException;
import org.apache.portals.applications.webcontent2.rewriter.impl.AbstractTextLineContentRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReverseProxyTextLineContentRewriter
extends AbstractTextLineContentRewriter {
    private static Logger log = LoggerFactory.getLogger(DefaultReverseProxyTextLineContentRewriter.class);
    protected static final Pattern LINK_PATTERN = Pattern.compile("(\\s|^)(href\\s*=\\s*|src\\s*=\\s*|action\\s*=\\s*|url\\s*\\(\\s*)((\"([^\"]*)\")|('([^']*)'))", 2);

    protected String rewriteLine(String line, ContentRewritingContext context) throws ContentRewritingException, IOException {
        CharSequence segment = new CharArraySegment(line);
        Matcher matcher = null;
        StringBuilder sbLine = new StringBuilder();
        boolean anyFound = false;
        String uri = null;
        matcher = LINK_PATTERN.matcher(segment);
        while (matcher.find()) {
            anyFound = true;
            sbLine.append(segment.subSequence(0, matcher.start())).append(matcher.group(1)).append(matcher.group(2));
            uri = matcher.group(5);
            if (uri != null) {
                sbLine.append('\"').append(this.rewriteURI(uri, context)).append('\"');
            } else {
                uri = matcher.group(7);
                sbLine.append('\'').append(this.rewriteURI(uri, context)).append('\'');
            }
            segment = segment.subSequence(matcher.end(), segment.length());
            matcher.reset(segment);
        }
        if (anyFound) {
            sbLine.append(segment);
            return sbLine.toString();
        }
        return line;
    }

    protected String rewriteURI(String uri, ContentRewritingContext context) {
        if (StringUtils.isBlank((String)uri)) {
            return uri;
        }
        if (!this.isRewritableURI(uri)) {
            return uri;
        }
        URI uriObj = null;
        try {
            uriObj = URI.create(uri);
        }
        catch (Exception e) {
            log.warn("Invalid uri: '{}'.", (Object)uri);
            return uri;
        }
        String scheme = uriObj.getScheme();
        if (scheme != null && !StringUtils.equalsIgnoreCase((String)scheme, (String)"http") && !StringUtils.equalsIgnoreCase((String)scheme, (String)"https")) {
            return uri;
        }
        ProxyContext proxyContext = (ProxyContext)((Object)context.getAttribute(ProxyContext.class.getName()));
        if (proxyContext == null) {
            log.warn("ProxyContext not found! No rewriting for '{}'.", (Object)uri);
            return uri;
        }
        RequestContext requestContext = proxyContext.getRequestContext();
        ProxyMapping currentMapping = (ProxyMapping)context.getAttribute(ProxyMapping.class.getName());
        ProxyMappingRegistry mappingRegistry = (ProxyMappingRegistry)context.getAttribute(ProxyMappingRegistry.class.getName());
        URI remoteURI = URIUtils.resolve((URI)proxyContext.getRemoteURI(), (URI)uriObj);
        String localPath = null;
        if (currentMapping.matchesRemote(remoteURI)) {
            localPath = currentMapping.resolveLocalFromRemote(remoteURI);
        } else {
            for (ProxyMapping proxyMapping : mappingRegistry.getProxyMappings()) {
                if (currentMapping == proxyMapping || !proxyMapping.matchesRemote(remoteURI)) continue;
                localPath = proxyMapping.resolveLocalFromRemote(remoteURI);
                break;
            }
        }
        if (localPath != null) {
            return new StringBuilder(80).append(requestContext.getRequestBasePath()).append(localPath).toString();
        }
        return uri;
    }

    protected boolean isRewritableURI(String uri) {
        return RewriterUtils.isRewritableURI(uri);
    }
}

