/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.portals.applications.webcontent2.proxy.HttpClientContextBuilder;
import org.apache.portals.applications.webcontent2.proxy.ProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.builder.ProxyServices;
import org.apache.portals.applications.webcontent2.proxy.impl.DefaultProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.impl.DefaultReverseProxyService;
import org.apache.portals.applications.webcontent2.proxy.impl.ProxyProcessingChain;
import org.apache.portals.applications.webcontent2.proxy.servlet.GenericReverseProxyServlet;
import org.apache.portals.applications.webcontent2.proxy.util.ProxyCommandUtils;
import org.apache.portals.applications.webcontent2.proxy.util.YamlConfigUtils;

public class SimpleReverseProxyServlet
extends GenericReverseProxyServlet {
    private static final long serialVersionUID = 1L;
    public static final String MAPPINGS_PARAM_NAME = "mappings";
    private ProxyMappingRegistry proxyMappingRegistry;
    private HttpClientBuilder httpClientBuilder;
    private HttpClientContextBuilder httpClientContextBuilder;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    private ProxyProcessingChain proxyServiceCommand;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initHostnameVerifier(servletConfig);
        this.proxyServiceCommand = this.createProxyServiceCommand();
        ProxyCommandUtils.initializeAllCommands(this.proxyServiceCommand);
        DefaultReverseProxyService proxyService = new DefaultReverseProxyService(this.proxyServiceCommand);
        this.setProxyService(proxyService);
    }

    protected void initHostnameVerifier(ServletConfig servletConfig) {
        String param = StringUtils.trim((String)servletConfig.getInitParameter("ssl-hostname-verifier"));
        if (StringUtils.isNotEmpty((String)param)) {
            if (StringUtils.equalsIgnoreCase((String)"ALLOW_ALL_HOSTNAME_VERIFIER", (String)param)) {
                this.setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            } else if (StringUtils.equalsIgnoreCase((String)"BROWSER_COMPATIBLE_HOSTNAME_VERIFIER", (String)param)) {
                this.setHostnameVerifier(SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            } else if (StringUtils.equalsIgnoreCase((String)"STRICT_HOSTNAME_VERIFIER", (String)param)) {
                this.setHostnameVerifier(SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
            }
        }
    }

    public ProxyMappingRegistry getProxyMappingRegistry() {
        if (this.proxyMappingRegistry == null) {
            this.proxyMappingRegistry = new DefaultProxyMappingRegistry();
            String param = this.getServletConfig().getInitParameter(MAPPINGS_PARAM_NAME);
            this.proxyMappingRegistry.addAllProxyMappings(YamlConfigUtils.loadProxyMappings(param, this.getServletContext()));
            return this.proxyMappingRegistry;
        }
        return this.proxyMappingRegistry;
    }

    public void setProxyMappingRegistry(ProxyMappingRegistry proxyMappingRegistry) {
        this.proxyMappingRegistry = proxyMappingRegistry;
    }

    public HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = this.createHttpClientBuilder();
        }
        return this.httpClientBuilder;
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    public HttpClientContextBuilder getHttpClientContextBuilder() {
        return this.httpClientContextBuilder;
    }

    public void setHttpClientContextBuilder(HttpClientContextBuilder httpClientContextBuilder) {
        this.httpClientContextBuilder = httpClientContextBuilder;
    }

    public LayeredConnectionSocketFactory getSslSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.createSslSocketFactory();
        }
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void destroy() {
        ProxyCommandUtils.destroyAllCommands(this.proxyServiceCommand);
        super.destroy();
    }

    protected ProxyProcessingChain createProxyServiceCommand() {
        return ProxyServices.createDefault().build(this.getProxyMappingRegistry(), this.getHttpClientBuilder(), this.getHttpClientContextBuilder());
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder builder = HttpClients.custom().disableRedirectHandling().useSystemProperties();
        LayeredConnectionSocketFactory sslSocketFactory = this.getSslSocketFactory();
        if (sslSocketFactory != null) {
            builder.setSSLSocketFactory(sslSocketFactory);
        }
        return builder;
    }

    protected LayeredConnectionSocketFactory createSslSocketFactory() {
        return new SSLConnectionSocketFactory(SSLContexts.createDefault(), this.getHostnameVerifier());
    }
}

