/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.util;

import javax.swing.text.Segment;

public class CharArraySegment
extends Segment
implements CharSequence {
    public CharArraySegment() {
    }

    public CharArraySegment(char[] array, int offset, int count) {
        super(array, offset, count);
    }

    public CharArraySegment(String s) {
        super(s.toCharArray(), 0, s.length());
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        return this.array[this.offset + index];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Invalid start index: " + start);
        }
        if (end > this.count) {
            throw new IllegalArgumentException("Invalid end index: " + end);
        }
        if (start > end) {
            throw new IllegalArgumentException("Invalid start and end index: " + start + " > " + end);
        }
        CharArraySegment charArraySegment = new CharArraySegment();
        charArraySegment.array = this.array;
        charArraySegment.offset = this.offset + start;
        charArraySegment.count = end - start;
        return charArraySegment;
    }
}

