/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.util;

import java.util.List;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.apache.portals.applications.webcontent2.proxy.impl.ProxyProcessingChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyCommandUtils {
    private static Logger log = LoggerFactory.getLogger(ProxyCommandUtils.class);

    private ProxyCommandUtils() {
    }

    public static void initializeAllCommands(ProxyProcessingChain chain) {
        if (chain == null) {
            return;
        }
        List<AbstractProxyCommand> allProxyCommands = chain.getAllProxyCommands();
        for (AbstractProxyCommand proxyCommand : allProxyCommands) {
            proxyCommand.initialize();
        }
    }

    public static void destroyAllCommands(ProxyProcessingChain chain) {
        if (chain == null) {
            return;
        }
        List<AbstractProxyCommand> allProxyCommands = chain.getAllProxyCommands();
        for (AbstractProxyCommand proxyCommand : allProxyCommands) {
            try {
                proxyCommand.destroy();
            }
            catch (Exception e) {
                log.error("Failed to destroy proxy command, " + proxyCommand, (Throwable)e);
            }
        }
    }
}

