/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.portals.applications.webcontent2.proxy.RequestContext;

public class RequestUtils {
    private RequestUtils() {
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        if (contextPath == null) {
            contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        }
        if (contextPath != null) {
            return contextPath;
        }
        return request.getContextPath();
    }

    public static String getRequestURI(HttpServletRequest request) {
        String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null) {
            requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
        }
        if (requestURI != null) {
            return requestURI;
        }
        return request.getRequestURI();
    }

    public static String getServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        }
        if (servletPath != null) {
            return servletPath;
        }
        return request.getServletPath();
    }

    public static String getPathInfo(HttpServletRequest request) {
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        if (pathInfo == null) {
            pathInfo = (String)request.getAttribute("javax.servlet.forward.path_info");
        }
        if (pathInfo != null) {
            return pathInfo;
        }
        return request.getPathInfo();
    }

    public static boolean isDispatched(RequestContext requestContext) {
        return requestContext.getAttribute("javax.servlet.include.context_path") != null || requestContext.getAttribute("javax.servlet.forward.context_path") != null;
    }
}

