/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.impl.RegexProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.impl.SimpleProxyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlConfigUtils {
    private static Logger log = LoggerFactory.getLogger(YamlConfigUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Object> loadYaml(BaseConstructor constructor, String yamlConfig, Object servletContextOrPortletContext) {
        Iterable allObjects = null;
        String mappingYaml = null;
        InputStream input = null;
        String mappings = StrSubstitutor.replaceSystemProperties((Object)yamlConfig);
        String trimmedMappings = StringUtils.trim((String)mappings);
        if (StringUtils.isNotEmpty((String)trimmedMappings)) {
            try {
                if (StringUtils.startsWith((String)trimmedMappings, (String)"file:")) {
                    input = new FileInputStream(new File(URI.create(trimmedMappings)));
                } else if (StringUtils.startsWith((String)trimmedMappings, (String)"classpath:")) {
                    input = Thread.currentThread().getContextClassLoader().getResourceAsStream(trimmedMappings.substring(10));
                } else if (StringUtils.startsWith((String)trimmedMappings, (String)"/")) {
                    input = (InputStream)MethodUtils.invokeMethod((Object)servletContextOrPortletContext, (String)"getResourceAsStream", (Object)trimmedMappings);
                } else {
                    mappingYaml = mappings;
                }
                if (mappingYaml == null && input != null) {
                    mappingYaml = IOUtils.toString((InputStream)input, (String)"UTF-8");
                }
                if (mappingYaml != null) {
                    Yaml yaml = new Yaml(constructor);
                    allObjects = yaml.loadAll(mappingYaml);
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            catch (Exception e) {
                log.error("Failed to load yaml configuration at '{}'. {}", (Object)yamlConfig, (Object)e);
            }
            finally {
                IOUtils.closeQuietly(input);
            }
        }
        return allObjects;
    }

    public static List<ProxyMapping> loadProxyMappings(String yamlConfig, Object servletContextOrPortletContext) {
        ArrayList<ProxyMapping> proxyMappings = new ArrayList<ProxyMapping>();
        Constructor constructor = new Constructor();
        constructor.addTypeDescription(new TypeDescription(SimpleProxyMapping.class, "!simple"));
        constructor.addTypeDescription(new TypeDescription(RegexProxyMapping.class, "!regex"));
        Iterable<Object> allObjects = YamlConfigUtils.loadYaml((BaseConstructor)constructor, yamlConfig, servletContextOrPortletContext);
        if (allObjects != null) {
            for (Object item : allObjects) {
                if (item instanceof Collection) {
                    for (Object mapping : (Collection)item) {
                        if (mapping instanceof ProxyMapping) {
                            proxyMappings.add((ProxyMapping)mapping);
                            continue;
                        }
                        log.error("Invalid mapping type: {} - {}" + mapping.getClass(), mapping);
                    }
                    continue;
                }
                if (item instanceof ProxyMapping) {
                    proxyMappings.add((ProxyMapping)item);
                    continue;
                }
                log.error("Invalid mapping type: {} - {}" + item.getClass(), item);
            }
        }
        return proxyMappings;
    }

    private YamlConfigUtils() {
    }
}

