/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.internal.shared.DeferredProperty;
import org.apache.sis.image.internal.shared.TiledImage;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.storage.base.TiledDeferredImage;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.util.GenericName;

public abstract class TiledGridCoverage
extends GridCoverage {
    protected static final int BIDIMENSIONAL = 2;
    protected static final int X_DIMENSION = 0;
    protected static final int Y_DIMENSION = 1;
    protected final GridExtent readExtent;
    private final long forceWholeTiles;
    private final long[] virtualTileSize;
    private final int[] tileStrides;
    private final int indexOfFirstTile;
    private final long[] tmcOfFirstTile;
    private final long[] subsampling;
    private final long[] subsamplingOffsets;
    protected final int[] includedBands;
    private final WeakValueHashMap<TiledGridResource.CacheKey, Raster> rasters;
    protected final SampleModel model;
    protected final ColorModel colors;
    protected final Number[] fillValues;
    private final boolean deferredTileReading;

    protected TiledGridCoverage(TiledGridResource.Subset subset) {
        super(subset.domain, subset.ranges);
        GridExtent extent = subset.domain.getExtent();
        this.deferredTileReading = subset.deferredTileReading();
        this.readExtent = subset.readExtent;
        this.subsampling = subset.subsampling;
        this.subsamplingOffsets = subset.subsamplingOffsets;
        this.includedBands = subset.includedBands;
        this.rasters = subset.cache;
        this.virtualTileSize = subset.virtualTileSize;
        int dimension = this.virtualTileSize.length;
        this.tmcOfFirstTile = new long[dimension];
        this.tileStrides = new int[dimension];
        int[] subSize = new int[dimension];
        long indexOfFirstTile = 0L;
        int tileStride = 1;
        for (int i = 0; i < dimension; ++i) {
            long ts = this.virtualTileSize[i];
            this.tmcOfFirstTile[i] = Math.floorDiv(this.readExtent.getLow(i), ts);
            this.tileStrides[i] = tileStride;
            subSize[i] = Math.toIntExact(Math.min((ts - 1L) / this.subsampling[i] + 1L, extent.getSize(i)));
            indexOfFirstTile = Math.addExact(indexOfFirstTile, Math.multiplyExact(this.tmcOfFirstTile[i], tileStride));
            int tileCount = Math.toIntExact(JDK18.ceilDiv((long)subset.sourceExtent.getSize(i), (long)ts));
            tileStride = Math.multiplyExact(tileCount, tileStride);
        }
        this.indexOfFirstTile = Math.toIntExact(indexOfFirstTile);
        SampleModel model = subset.modelForBandSubset;
        if (model.getWidth() != subSize[0] || model.getHeight() != subSize[1]) {
            model = model.createCompatibleSampleModel(subSize[0], subSize[1]);
        }
        this.model = model;
        this.colors = subset.colorsForBandSubset;
        this.fillValues = subset.fillValues;
        this.forceWholeTiles = subset.forceWholeTiles(subSize);
    }

    protected abstract GenericName getIdentifier();

    protected Locale getLocale() {
        return null;
    }

    protected final long getTileSize(int dimension) {
        return this.virtualTileSize[dimension];
    }

    protected final long getSubsampling(int dimension) {
        return this.subsampling[dimension];
    }

    private int[] uncroppedTileLocation(int[] tileLower) {
        int[] offsets = null;
        int dimension = this.virtualTileSize.length;
        for (int i = 0; i < dimension; ++i) {
            long tileIndex = Math.addExact(this.tmcOfFirstTile[i], (long)tileLower[i]);
            long tileBase = Math.multiplyExact(tileIndex, this.virtualTileSize[i]);
            long offset = Math.max(Math.subtractExact(this.readExtent.getLow(i), tileBase), 0L);
            if (offset == 0L) continue;
            if (offsets == null) {
                offsets = new int[dimension];
            }
            offsets[i] = Math.toIntExact(-offset / this.subsampling[i]);
        }
        return offsets;
    }

    protected final long coverageToResourceCoordinate(long coordinate, int dimension) {
        return Math.addExact(Math.multiplyExact(coordinate, this.subsampling[dimension]), this.subsamplingOffsets[dimension]);
    }

    private long resourceToCoverageCoordinate(long coordinate, int dimension) {
        return Math.floorDiv(Math.subtractExact(coordinate, this.subsamplingOffsets[dimension]), this.subsampling[dimension]);
    }

    final long coverageTileToResourceCell(long tileIndex, int dimension) {
        return Math.multiplyExact(Math.addExact(tileIndex, this.tmcOfFirstTile[dimension]), this.virtualTileSize[dimension]);
    }

    private long coverageCellToResourceTile(long coordinate, int dimension) {
        return Math.floorDiv(this.coverageToResourceCoordinate(coordinate, dimension), this.virtualTileSize[dimension]);
    }

    protected final int getPixelsPerElement() {
        return TiledGridCoverage.getPixelsPerElement(this.model);
    }

    static int getPixelsPerElement(SampleModel model) {
        int sampleSize;
        int typeSize;
        int pixelsPerElement;
        if (model instanceof MultiPixelPackedSampleModel && (pixelsPerElement = (typeSize = DataBuffer.getDataTypeSize(model.getDataType())) / (sampleSize = ((MultiPixelPackedSampleModel)model).getPixelBitStride())) > 0) {
            return pixelsPerElement;
        }
        return 1;
    }

    protected final Rectangle bidimensional(GridExtent extent) {
        if (extent == null) {
            return null;
        }
        return new Rectangle(Math.toIntExact(extent.getLow(0)), Math.toIntExact(extent.getLow(1)), Math.toIntExact(extent.getSize(0)), Math.toIntExact(extent.getSize(1)));
    }

    public RenderedImage render(GridExtent sliceExtent) {
        TiledDeferredImage image;
        GridExtent available = this.gridGeometry.getExtent();
        int dimension = this.virtualTileSize.length;
        if (sliceExtent == null) {
            sliceExtent = available;
        } else {
            int sd = sliceExtent.getDimension();
            if (sd < dimension || sd > available.getDimension()) {
                throw new MismatchedDimensionException(Errors.format((short)101, (Object)"sliceExtent", (Object)dimension, (Object)sd));
            }
        }
        int[] selectedDimensions = sliceExtent.getSubspaceDimensions(2);
        if (selectedDimensions[1] != 1) {
            throw new UnsupportedOperationException("Non-horizontal slices not yet implemented.");
        }
        try {
            int[] tileLower = new int[dimension];
            int[] tileUpper = new int[dimension];
            int[] offsetAOI = new int[dimension];
            int[] imageSize = new int[dimension];
            for (int i = 0; i < dimension; ++i) {
                long tileLo;
                long min = available.getLow(i);
                long max = available.getHigh(i);
                long aoiMin = sliceExtent.getLow(i);
                long aoiMax = sliceExtent.getHigh(i);
                long tileUp = Math.incrementExact(this.coverageCellToResourceTile(Math.min(aoiMax, max), i));
                if (tileUp <= (tileLo = this.coverageCellToResourceTile(Math.max(aoiMin, min), i))) {
                    String message = Errors.forLocale((Locale)this.getLocale()).getString((short)76, (Object)aoiMin, (Object)aoiMax);
                    if (aoiMin > aoiMax) {
                        throw new IllegalArgumentException(message);
                    }
                    throw new DisjointExtentException(message);
                }
                long lower = Math.max(this.resourceToCoverageCoordinate(Math.multiplyExact(tileLo, this.virtualTileSize[i]), i), min);
                long upper = Math.incrementExact(Math.min(this.resourceToCoverageCoordinate(Math.decrementExact(Math.multiplyExact(tileUp, this.virtualTileSize[i])), i), max));
                imageSize[i] = Math.toIntExact(Math.subtractExact(upper, lower));
                offsetAOI[i] = Math.toIntExact(Math.subtractExact(lower, aoiMin));
                tileLower[i] = Math.toIntExact(Math.subtractExact(tileLo, this.tmcOfFirstTile[i]));
                tileUpper[i] = Math.toIntExact(Math.subtractExact(tileUp, this.tmcOfFirstTile[i]));
            }
            TileIterator iterator = new TileIterator(tileLower, tileUpper, offsetAOI, dimension);
            Map properties = DeferredProperty.forGridGeometry((GridGeometry)this.gridGeometry, (int[])selectedDimensions);
            if (this.deferredTileReading) {
                image = new TiledDeferredImage(imageSize, tileLower, properties, iterator);
            } else {
                Raster[] result = this.readTiles(iterator);
                image = new TiledImage(properties, this.colors, imageSize[0], imageSize[1], tileLower[0], tileLower[1], result);
            }
        }
        catch (Exception e) {
            throw new CannotEvaluateException(Resources.forLocale(this.getLocale()).getString((short)61, this.getIdentifier().toFullyQualifiedName()), (Throwable)e);
        }
        return image;
    }

    private TiledGridResource.CacheKey createCacheKey(int indexInTileVector) {
        return new TiledGridResource.CacheKey(indexInTileVector, this.includedBands, this.subsampling, this.subsamplingOffsets);
    }

    private Raster getCachedTile(int indexInTileVector) {
        return (Raster)this.rasters.get((Object)this.createCacheKey(indexInTileVector));
    }

    private Raster cacheTile(int indexInTileVector, Raster tile) {
        TiledGridResource.CacheKey key = this.createCacheKey(indexInTileVector);
        Raster existing = (Raster)this.rasters.put((Object)key, (Object)tile);
        if (existing != null && existing.getSampleModel().equals(tile.getSampleModel()) && existing.getWidth() == tile.getWidth() && existing.getHeight() == tile.getHeight() && this.rasters.replace((Object)key, (Object)tile, (Object)existing)) {
            int x = tile.getMinX();
            int y = tile.getMinY();
            if (existing.getMinX() != x || existing.getMinY() != y) {
                existing = existing.createTranslatedChild(x, y);
            }
            return existing;
        }
        return tile;
    }

    protected abstract Raster[] readTiles(TileIterator var1) throws Exception;

    protected final class TileIterator
    extends AOI {
        public final int tileCountInQuery;
        private final int[] tileLower;
        private final int[] tileUpper;
        private final int[] offsetAOI;
        private final long[] tileOffsetFull;

        TileIterator(int[] tileLower, int[] tileUpper, int[] offsetAOI, int dimension) {
            super((int[])tileLower.clone(), TiledGridCoverage.this.uncroppedTileLocation(tileLower));
            this.tileLower = tileLower;
            this.tileUpper = tileUpper;
            this.offsetAOI = offsetAOI;
            this.tileOffsetFull = new long[offsetAOI.length];
            this.indexInTileVector = TiledGridCoverage.this.indexOfFirstTile;
            int tileCountInQuery = 1;
            for (int i = 0; i < dimension; ++i) {
                int lower = tileLower[i];
                int count = Math.subtractExact(tileUpper[i], lower);
                this.indexInTileVector = Math.addExact(this.indexInTileVector, Math.multiplyExact(TiledGridCoverage.this.tileStrides[i], lower));
                tileCountInQuery = Math.multiplyExact(tileCountInQuery, count);
                this.tileOffsetFull[i] = Math.multiplyExact(TiledGridCoverage.this.getSubsampling(i), offsetAOI[i]);
                long max = Math.addExact((long)offsetAOI[i], Math.multiplyExact(TiledGridCoverage.this.getTileSize(i), count));
                assert (max > (long)Math.max(offsetAOI[i], 0)) : max;
            }
            this.tileCountInQuery = tileCountInQuery;
        }

        public TileIterator subset(int[] firstTile, int[] endTile) {
            int[] offset = (int[])this.offsetAOI.clone();
            int[] lower = (int[])this.tileLower.clone();
            int i = Math.min(firstTile.length, lower.length);
            while (--i >= 0) {
                int s = firstTile[i];
                int base = lower[i];
                if (s <= base) continue;
                lower[i] = s;
                long origin = JDK18.ceilDiv((long)Math.multiplyExact(TiledGridCoverage.this.getTileSize(i), s - base), (long)TiledGridCoverage.this.getSubsampling(i));
                offset[i] = Math.toIntExact(Math.addExact(origin, (long)offset[i]));
            }
            int[] upper = (int[])this.tileUpper.clone();
            int i2 = Math.min(endTile.length, upper.length);
            while (--i2 >= 0) {
                upper[i2] = Math.max(lower[i2], Math.min(upper[i2], endTile[i2]));
            }
            return new TileIterator(lower, upper, offset, offset.length);
        }

        @Override
        final TiledGridCoverage getCoverage() {
            return TiledGridCoverage.this;
        }

        public GridExtent getFullRegionInResourceCoordinates() {
            int dimension = this.tileLower.length;
            DimensionNameType[] axes = new DimensionNameType[dimension];
            long[] lower = new long[dimension];
            long[] upper = new long[dimension];
            for (int i = 0; i < dimension; ++i) {
                axes[i] = TiledGridCoverage.this.readExtent.getAxisType(i).orElse(null);
                lower[i] = Math.max(TiledGridCoverage.this.coverageTileToResourceCell(this.tileLower[i], i), TiledGridCoverage.this.readExtent.getLow(i));
                upper[i] = Math.min(TiledGridCoverage.this.coverageTileToResourceCell(this.tileUpper[i], i) - 1L, TiledGridCoverage.this.readExtent.getHigh(i));
            }
            return new GridExtent(axes, lower, upper, true);
        }

        public long resourceToImage(long coordinate, int dimension, boolean ceil) {
            coordinate = Math.subtractExact(coordinate, TiledGridCoverage.this.coverageTileToResourceCell(this.tileLower[dimension], dimension));
            long s = TiledGridCoverage.this.getSubsampling(dimension);
            coordinate = ceil ? JDK18.ceilDiv((long)coordinate, (long)s) : Math.floorDiv(coordinate, s);
            coordinate = Math.addExact(coordinate, (long)this.offsetAOI[dimension]);
            return coordinate;
        }

        public long imageToResource(long coordinate, int dimension) {
            coordinate = Math.subtractExact(coordinate, (long)this.offsetAOI[dimension]);
            coordinate = Math.multiplyExact(coordinate, TiledGridCoverage.this.getSubsampling(dimension));
            coordinate = Math.addExact(coordinate, TiledGridCoverage.this.coverageTileToResourceCell(this.tileLower[dimension], dimension));
            return coordinate;
        }

        public Rectangle resourceToImage(Rectangle bounds, boolean tight) {
            long d = tight ? 1L : 0L;
            Rectangle r = new Rectangle();
            long x = bounds.x;
            r.x = Math.toIntExact(this.resourceToImage(x, 0, false));
            long y = bounds.y;
            r.y = Math.toIntExact(this.resourceToImage(y, 1, false));
            r.width = Math.toIntExact(this.resourceToImage(x + (long)bounds.width - d, 0, true) - (long)r.x + d);
            r.height = Math.toIntExact(this.resourceToImage(y + (long)bounds.height - d, 1, true) - (long)r.y + d);
            return r;
        }

        public Rectangle imageToResource(Rectangle bounds, boolean tight) {
            long d = tight ? 1L : 0L;
            Rectangle r = new Rectangle();
            long x = bounds.x;
            r.x = Math.toIntExact(this.imageToResource(x, 0));
            long y = bounds.y;
            r.y = Math.toIntExact(this.imageToResource(y, 1));
            r.width = Math.toIntExact(this.imageToResource(x + (long)bounds.width - d, 0) - (long)r.x + d);
            r.height = Math.toIntExact(this.imageToResource(y + (long)bounds.height - d, 1) - (long)r.y + d);
            return r;
        }

        @Override
        final int getTileOrigin(int dimension) {
            return Math.toIntExact(JDK18.ceilDiv((long)this.tileOffsetFull[dimension], (long)TiledGridCoverage.this.getSubsampling(dimension)));
        }

        public boolean next() {
            if (++this.indexInResultArray >= this.tileCountInQuery) {
                return false;
            }
            for (int i = 0; i < this.tmcInSubset.length; ++i) {
                this.indexInTileVector += TiledGridCoverage.this.tileStrides[i];
                int n = i;
                this.tmcInSubset[n] = this.tmcInSubset[n] + 1;
                if (this.tmcInSubset[n] < this.tileUpper[i]) {
                    int n2 = i;
                    this.tileOffsetFull[n2] = this.tileOffsetFull[n2] + TiledGridCoverage.this.getTileSize(i);
                    break;
                }
                this.indexInTileVector -= (this.tmcInSubset[i] - this.tileLower[i]) * TiledGridCoverage.this.tileStrides[i];
                this.tmcInSubset[i] = this.tileLower[i];
                this.tileOffsetFull[i] = Math.multiplyExact(TiledGridCoverage.this.getSubsampling(i), this.offsetAOI[i]);
            }
            return true;
        }
    }

    protected static class Snapshot
    extends AOI {
        private final TiledGridCoverage coverage;
        public final int originX;
        public final int originY;

        public Snapshot(AOI iterator) {
            super((int[])iterator.tmcInSubset.clone(), iterator.uncroppedTileLocation);
            this.coverage = iterator.getCoverage();
            this.indexInResultArray = iterator.indexInResultArray;
            this.indexInTileVector = iterator.indexInTileVector;
            this.originX = iterator.getTileOrigin(0);
            this.originY = iterator.getTileOrigin(1);
        }

        @Override
        final TiledGridCoverage getCoverage() {
            return this.coverage;
        }

        @Override
        final int getTileOrigin(int dimension) {
            switch (dimension) {
                case 0: {
                    return this.originX;
                }
                case 1: {
                    return this.originY;
                }
            }
            throw new AssertionError(dimension);
        }
    }

    protected static abstract class AOI {
        final int[] tmcInSubset;
        int indexInResultArray;
        int indexInTileVector;
        final int[] uncroppedTileLocation;

        AOI(int[] tmcInSubset, int[] uncroppedTileLocation) {
            this.tmcInSubset = tmcInSubset;
            this.uncroppedTileLocation = uncroppedTileLocation;
        }

        abstract TiledGridCoverage getCoverage();

        public final long[] getTileCoordinatesInResource() {
            long[] tmcOfFirstTile = this.getCoverage().tmcOfFirstTile;
            long[] coordinate = new long[tmcOfFirstTile.length];
            for (int i = 0; i < coordinate.length; ++i) {
                coordinate[i] = Math.addExact(tmcOfFirstTile[i], (long)this.tmcInSubset[i]);
            }
            return coordinate;
        }

        public final int getTileIndexInResource() {
            return this.indexInTileVector;
        }

        public final int getTileIndexInResultArray() {
            return this.indexInResultArray;
        }

        abstract int getTileOrigin(int var1);

        public Raster getCachedTile() {
            TiledGridCoverage coverage = this.getCoverage();
            Raster tile = coverage.getCachedTile(this.indexInTileVector);
            if (tile != null) {
                int x = this.getTileOrigin(0);
                int y = this.getTileOrigin(1);
                SampleModel model = coverage.model;
                if (model.equals(tile.getSampleModel())) {
                    if (tile.getMinX() == x && tile.getMinY() == y) {
                        return tile;
                    }
                    return tile.createTranslatedChild(x, y);
                }
                SampleModel sm = tile.getSampleModel();
                if (sm.getWidth() == model.getWidth() && sm.getHeight() == model.getHeight()) {
                    int width = tile.getWidth();
                    int height = tile.getHeight();
                    Raster r = Raster.createRaster(model, tile.getDataBuffer(), new Point(x, y));
                    if (r.getWidth() != width || r.getHeight() != height) {
                        r = r.createChild(x, y, width, height, x, y, null);
                    }
                    return r;
                }
            }
            return null;
        }

        public Raster cache(Raster tile) {
            return this.getCoverage().cacheTile(this.indexInTileVector, tile);
        }

        public WritableRaster createRaster() {
            int x = this.getTileOrigin(0);
            int y = this.getTileOrigin(1);
            return Raster.createWritableRaster(this.getCoverage().model, new Point(x, y));
        }

        public Raster moveRaster(Raster raster) {
            int x = this.getTileOrigin(0);
            int y = this.getTileOrigin(1);
            if (raster.getMinX() == x && raster.getMinY() == y) {
                return raster;
            }
            return raster.createTranslatedChild(x, y);
        }

        public Optional<Point> getUncroppedTileLocation() {
            if (this.uncroppedTileLocation == null) {
                return Optional.empty();
            }
            return Optional.of(new Point(this.uncroppedTileLocation[0], this.uncroppedTileLocation[1]));
        }

        public Rectangle getRegionInsideTile(boolean subsampled) {
            long[] lower = new long[2];
            long[] upper = new long[2];
            if (this.getRegionInsideTile(lower, upper, null, subsampled)) {
                return new Rectangle(Math.toIntExact(lower[0]), Math.toIntExact(lower[1]), Math.toIntExact(Math.subtractExact(upper[0], lower[0])), Math.toIntExact(Math.subtractExact(upper[1], lower[1])));
            }
            return null;
        }

        public boolean getRegionInsideTile(long[] lower, long[] upper, long[] subsampling, boolean subsampled) {
            int dimension = Math.min(lower.length, upper.length);
            TiledGridCoverage coverage = this.getCoverage();
            if (subsampling != null) {
                System.arraycopy(coverage.subsampling, 0, subsampling, 0, dimension);
            }
            while (--dimension >= 0) {
                long tileSize = coverage.getTileSize(dimension);
                long tileIndex = Math.addExact(coverage.tmcOfFirstTile[dimension], (long)this.tmcInSubset[dimension]);
                long tileBase = Math.multiplyExact(tileIndex, tileSize);
                long offset = Math.subtractExact(coverage.readExtent.getLow(dimension), tileBase);
                long limit = Math.min(Math.addExact(offset, coverage.readExtent.getSize(dimension)), tileSize);
                long s = coverage.getSubsampling(dimension);
                if (offset < 0L && (offset %= s) != 0L) {
                    offset += s;
                }
                if (offset >= limit) {
                    return false;
                }
                if ((coverage.forceWholeTiles & Numerics.bitmask((int)dimension)) != 0L) {
                    limit = tileSize;
                }
                if (subsampled) {
                    offset /= s;
                    limit = (limit - 1L) / s + 1L;
                }
                lower[dimension] = offset;
                upper[dimension] = limit;
            }
            return true;
        }
    }
}

