/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;

public class WarningEvent
extends StoreEvent {
    private static final long serialVersionUID = 3825327888379868663L;
    private final LogRecord description;

    public WarningEvent(Resource source, LogRecord description) {
        super(source);
        this.description = Objects.requireNonNull(description);
    }

    public LogRecord getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        Level level = this.description.getLevel();
        if (level != null) {
            b.append(level.getLocalizedName()).append(": ");
        }
        b.append(this.description.getMessage());
        Throwable cause = this.description.getThrown();
        if (cause != null) {
            b.append(System.lineSeparator()).append("Caused by ").append(cause);
        }
        return b.toString();
    }
}

