/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.SelectionModel;

final class BandSelectionListener
implements ChangeListener<Number> {
    private final IntegerProperty bandProperty;
    private boolean isAdjusting;

    static void bind(IntegerProperty bandProperty, SelectionModel<?> bandSelection) {
        bandSelection.selectedIndexProperty().addListener((ChangeListener)new BandSelectionListener(bandProperty));
        bandProperty.addListener((p, o, n) -> bandSelection.clearAndSelect(n.intValue()));
    }

    private BandSelectionListener(IntegerProperty bandProperty) {
        this.bandProperty = bandProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
        int row = newValue.intValue();
        if (row >= 0 && !this.isAdjusting) {
            try {
                this.isAdjusting = true;
                this.bandProperty.set(row);
            }
            finally {
                this.isAdjusting = false;
            }
        }
    }
}

