/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.configurator.impl.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.feature.io.impl.felix.configurator.impl.model.Config;
import org.apache.sling.feature.io.impl.felix.configurator.impl.model.ConfigList;

public class AbstractState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private Map<String, ConfigList> configurationsByPid = new TreeMap<String, ConfigList>();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.configurationsByPid);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        this.configurationsByPid = (Map)in.readObject();
    }

    public void add(Config c) {
        ConfigList configs = this.configurationsByPid.get(c.getPid());
        if (configs == null) {
            configs = new ConfigList();
            this.configurationsByPid.put(c.getPid(), configs);
        }
        configs.add(c);
    }

    public Map<String, ConfigList> getConfigurations() {
        return this.configurationsByPid;
    }

    public ConfigList getConfigurations(String pid) {
        return this.getConfigurations().get(pid);
    }

    public Collection<String> getPids() {
        return this.getConfigurations().keySet();
    }
}

