/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.helper;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChainedIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> iterators;
    private Iterator<T> currentIterator;
    private T currentItem;

    public ChainedIterator(Iterator<T> ... iterators) {
        this(Arrays.asList(iterators));
    }

    public ChainedIterator(Iterator<T> iterator1, Iterator<T> iterator2) {
        this(Arrays.asList(iterator1, iterator2));
    }

    public ChainedIterator(Iterable<Iterator<T>> iterators) {
        this.iterators = iterators.iterator();
        this.seek();
    }

    private void seek() {
        while (this.currentItem == null) {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                this.currentItem = this.currentIterator.next();
                continue;
            }
            if (!this.iterators.hasNext()) break;
            this.currentIterator = this.iterators.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentItem != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = this.currentItem;
        this.currentItem = null;
        this.seek();
        return item;
    }
}

